/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.axis2.transport.http.server.HttpRequestHandler;
import org.apache.axis2.transport.http.server.HttpService;
import org.apache.axis2.transport.http.server.HttpServiceHandler;
import org.apache.axis2.transport.http.server.SimpleConnSet;
import org.apache.axis2.transport.http.server.SimpleConnectionThread;
import org.apache.axis2.transport.http.server.SimpleHttpServerConnection;
import org.apache.axis2.transport.http.server.SimplePlainSocketFactory;
import org.apache.axis2.transport.http.server.SimpleSocketFactory;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.axis2.util.threadpool.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleHttpServer
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$axis2$transport$http$server$SimpleHttpServer == null ? (class$org$apache$axis2$transport$http$server$SimpleHttpServer = SimpleHttpServer.class$("org.apache.axis2.transport.http.server.SimpleHttpServer")) : class$org$apache$axis2$transport$http$server$SimpleHttpServer));
    private String testname = "Simple test";
    private ServerSocket listener = null;
    private long count = 0L;
    private ThreadFactory threadPool = null;
    private boolean stopped = false;
    private HttpRequestHandler requestHandler = null;
    private SimpleConnSet connectionsPool = new SimpleConnSet();
    private Thread t;
    static /* synthetic */ Class class$org$apache$axis2$transport$http$server$SimpleHttpServer;

    public SimpleHttpServer() throws IOException {
        this(null, 0, null);
    }

    public SimpleHttpServer(int port) throws IOException {
        this(null, port, null);
    }

    public SimpleHttpServer(int port, ThreadFactory threadPool) throws IOException {
        this(null, port, threadPool);
    }

    public SimpleHttpServer(SimpleSocketFactory socketfactory, int port) throws IOException {
        this(socketfactory, port, null);
    }

    public SimpleHttpServer(SimpleSocketFactory socketfactory, int port, ThreadFactory threadPool) throws IOException {
        if (socketfactory == null) {
            socketfactory = new SimplePlainSocketFactory();
        }
        if (threadPool == null) {
            threadPool = new ThreadPool();
        }
        this.threadPool = threadPool;
        this.listener = socketfactory.createServerSocket(port);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting test HTTP server on port " + this.getLocalPort()));
        }
        this.t = new Thread(this);
        this.t.start();
    }

    public synchronized void destroy() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stopping test HTTP server on port " + this.getLocalPort()));
        }
        this.t.interrupt();
        if (this.listener != null) {
            try {
                this.listener.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.connectionsPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.stopped && !Thread.interrupted()) {
                Socket socket = this.listener.accept();
                try {
                    if (this.requestHandler == null) {
                        socket.close();
                        break;
                    }
                    SimpleHttpServerConnection conn = new SimpleHttpServerConnection(socket);
                    this.connectionsPool.addConnection(conn);
                    this.threadPool.execute(new SimpleConnectionThread(this.testname + " thread " + this.count, conn, this.connectionsPool, this.requestHandler));
                }
                catch (IOException e) {
                    LOG.debug((Object)("I/O error: " + e.getMessage()));
                }
                ++this.count;
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException accept) {
        }
        catch (IOException e) {
            if (!this.stopped) {
                LOG.debug((Object)("I/O error: " + e.getMessage()));
            }
        }
        finally {
            this.destroy();
        }
    }

    public String getLocalAddress() {
        InetAddress address = this.listener.getInetAddress();
        byte[] octets = address.getAddress();
        if (octets[0] == 0 && octets[1] == 0 && octets[2] == 0 && octets[3] == 0) {
            return "localhost";
        }
        return address.getHostAddress();
    }

    public int getLocalPort() {
        return this.listener.getLocalPort();
    }

    public HttpRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public String getTestname() {
        return this.testname;
    }

    public boolean isRunning() {
        if (this.t == null) {
            return false;
        }
        return this.t.isAlive();
    }

    public void setHttpService(HttpService service) {
        this.setRequestHandler(new HttpServiceHandler(service));
    }

    public void setRequestHandler(HttpRequestHandler rh) {
        this.requestHandler = rh;
    }

    public void setTestname(String testname) {
        this.testname = testname;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

