/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.axis2.transport.http.server.RequestLine;
import org.apache.axis2.transport.http.server.ResponseWriter;
import org.apache.axis2.transport.http.server.SimpleRequest;
import org.apache.axis2.transport.http.server.SimpleResponse;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;

public class SimpleHttpServerConnection {
    private static final String HTTP_ELEMENT_CHARSET = "US-ASCII";
    private Socket socket = null;
    private OutputStream out = null;
    private boolean keepAlive = false;
    private InputStream in = null;
    public static final int DEFAULT_TIMEOUT = 60000;

    public SimpleHttpServerConnection(Socket socket) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.socket.setSoTimeout(60000);
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    public synchronized void close() {
        try {
            if (this.socket != null) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.in.close();
                this.out.close();
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SimpleRequest readRequest() throws IOException {
        try {
            String line = null;
            while ((line = HttpParser.readLine((InputStream)this.in, (String)HTTP_ELEMENT_CHARSET)) != null && line.length() == 0) {
            }
            if (line == null) {
                this.setKeepAlive(false);
                return null;
            }
            SimpleRequest request = new SimpleRequest(RequestLine.parseLine(line), HttpParser.parseHeaders((InputStream)this.in, (String)HTTP_ELEMENT_CHARSET), this.in);
            return request;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public SimpleResponse readResponse() throws IOException {
        try {
            String line = null;
            while ((line = HttpParser.readLine((InputStream)this.in, (String)HTTP_ELEMENT_CHARSET)) != null && line.length() == 0) {
            }
            if (line == null) {
                this.setKeepAlive(false);
                return null;
            }
            SimpleResponse response = new SimpleResponse(new StatusLine(line), HttpParser.parseHeaders((InputStream)this.in, (String)HTTP_ELEMENT_CHARSET), this.in);
            return response;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void writeRequest(SimpleRequest request) throws IOException {
        if (request == null) {
            return;
        }
        ResponseWriter writer = new ResponseWriter(this.out, HTTP_ELEMENT_CHARSET);
        writer.println(request.getRequestLine().toString());
        Iterator item = request.getHeaderIterator();
        while (item.hasNext()) {
            Header header = (Header)item.next();
            writer.print(header.toExternalForm());
        }
        writer.println();
        writer.flush();
        OutputStream outsream = this.out;
        InputStream content = request.getBody();
        if (content != null) {
            Header transferenc = request.getFirstHeader("Transfer-Encoding");
            if (transferenc != null) {
                request.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") != -1) {
                    outsream = new ChunkedOutputStream(outsream);
                }
            }
            byte[] tmp = new byte[4096];
            int i = 0;
            while ((i = content.read(tmp)) >= 0) {
                outsream.write(tmp, 0, i);
            }
            if (outsream instanceof ChunkedOutputStream) {
                ((ChunkedOutputStream)outsream).finish();
            }
        }
        outsream.flush();
    }

    public void writeResponse(SimpleResponse response) throws IOException {
        OutputStream outsream;
        block4: {
            InputStream content;
            block5: {
                if (response == null) {
                    return;
                }
                ResponseWriter writer = new ResponseWriter(this.out, HTTP_ELEMENT_CHARSET);
                writer.println(response.getStatusLine());
                Iterator item = response.getHeaderIterator();
                while (item.hasNext()) {
                    Header header = (Header)item.next();
                    writer.print(header.toExternalForm());
                }
                writer.println();
                writer.flush();
                outsream = this.out;
                content = response.getBody();
                if (content == null) break block4;
                Header transferenc = response.getFirstHeader("Transfer-Encoding");
                if (transferenc == null) break block5;
                response.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") == -1) break block4;
                outsream = new ChunkedOutputStream(outsream);
                byte[] tmp = new byte[1024];
                int i = 0;
                while ((i = content.read(tmp)) >= 0) {
                    outsream.write(tmp, 0, i);
                }
                if (!(outsream instanceof ChunkedOutputStream)) break block4;
                ((ChunkedOutputStream)outsream).finish();
                break block4;
            }
            byte[] tmp = new byte[1024];
            int i = 0;
            while ((i = content.read(tmp)) >= 0) {
                outsream.write(tmp, 0, i);
            }
        }
        outsream.flush();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getSocketTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public ResponseWriter getWriter() throws UnsupportedEncodingException {
        return new ResponseWriter(this.out);
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public synchronized boolean isOpen() {
        return this.socket != null;
    }

    public void setKeepAlive(boolean b) {
        this.keepAlive = b;
    }

    public void setSocketTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public String getURL(String suffix) throws Exception {
        String hostAddress = SimpleHttpServerConnection.getIpAddress();
        return "http://" + hostAddress + ":" + this.socket.getLocalPort() + "/" + suffix;
    }

    public static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = null;
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                address = ip.getHostAddress();
            }
        }
        return address;
    }
}

