/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMOutputFormat;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.jms.JMSConnector;
import org.apache.axis2.transport.jms.JMSConnectorManager;
import org.apache.axis2.transport.jms.JMSEndpoint;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSURLHelper;
import org.apache.axis2.transport.jms.JMSVendorAdapter;
import org.apache.axis2.transport.jms.JMSVendorAdapterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSSender
extends AbstractHandler
implements TransportSender {
    private static final long serialVersionUID = -3883554138407525394L;
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis2$transport$jms$JMSSender == null ? (class$org$apache$axis2$transport$jms$JMSSender = JMSSender.class$("org.apache.axis2.transport.jms.JMSSender")) : class$org$apache$axis2$transport$jms$JMSSender).getName());
    HashMap params = new HashMap();
    static /* synthetic */ Class class$org$apache$axis2$transport$jms$JMSSender;

    public void cleanUp(MessageContext msgContext) throws AxisFault {
    }

    public static void closeAllConnectors() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JMSTransport::closeAllConnectors");
        }
        JMSConnectorManager.getInstance().closeAllConnectors();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JMSTransport::closeAllConnectors");
        }
    }

    public static void closeMatchingJMSConnectors(String endpointAddr, String username, String password) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JMSTransport::closeMatchingJMSConnectors");
        }
        try {
            JMSURLHelper jmsurl = new JMSURLHelper(endpointAddr);
            String vendorId = jmsurl.getVendor();
            JMSVendorAdapter vendorAdapter = null;
            if (vendorId == null) {
                vendorId = "JNDI";
            }
            if ((vendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter(vendorId)) == null) {
                return;
            }
            HashMap connectorProps = vendorAdapter.getJMSConnectorProperties(jmsurl);
            HashMap cfProps = vendorAdapter.getJMSConnectionFactoryProperties(jmsurl);
            JMSConnectorManager.getInstance().closeMatchingJMSConnectors(connectorProps, cfProps, username, password, vendorAdapter);
        }
        catch (Exception e) {
            log.warn((Object)Messages.getMessage("malformedURLException00"), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JMSTransport::closeMatchingJMSConnectors");
        }
    }

    protected HashMap createApplicationProperties(MessageContext context) {
        HashMap props = new HashMap();
        if (context.getProperty("transport.jms.msgProps") != null) {
            props.putAll((Map)context.getProperty("transport.jms.msgProps"));
        }
        return props;
    }

    private HashMap createSendProperties(MessageContext context) {
        HashMap props = this.createApplicationProperties(context);
        if (context.getProperty("transport.jms.priority") != null) {
            props.put("transport.jms.priority", context.getProperty("transport.jms.priority"));
        }
        if (context.getProperty("transport.jms.deliveryMode") != null) {
            props.put("transport.jms.deliveryMode", context.getProperty("transport.jms.deliveryMode"));
        }
        if (context.getProperty("transport.jms.ttl") != null) {
            props.put("transport.jms.ttl", context.getProperty("transport.jms.ttl"));
        }
        if (context.getProperty("transport.jms.jmsCorrelationID") != null) {
            props.put("transport.jms.jmsCorrelationID", context.getProperty("transport.jms.jmsCorrelationID"));
        }
        return props;
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
        Iterator iterator = transportOut.getParameters().iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            this.params.put(param.getName(), param.getValue());
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        JMSOutTransportInfo transportInfo;
        JMSConnector connector = null;
        HashMap properties = null;
        Destination dest = null;
        if (msgContext.isServerSide() && (transportInfo = (JMSOutTransportInfo)msgContext.getProperty("OutTransportInfo")) != null) {
            dest = transportInfo.getDestination();
            properties = transportInfo.getProperties();
        }
        String endpointAddress = msgContext.getTo().getAddress();
        boolean waitForResponse = false;
        if (dest == null) {
            if (msgContext.getProperty("IsUsingSeparateListener") != null && msgContext.getProperty("IsUsingSeparateListener").equals(Boolean.TRUE)) {
                waitForResponse = (Boolean)msgContext.getProperty("IsUsingSeparateListener") == false;
            }
        } else if (properties != null) {
            JMSURLHelper url = null;
            try {
                url = new JMSURLHelper("jms:/" + dest);
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
            url.getProperties().putAll(properties);
            endpointAddress = url.getURLString();
        }
        this.setupTransport(msgContext, endpointAddress);
        if (connector == null) {
            connector = (JMSConnector)msgContext.getProperty("transport.jms.Connector");
        }
        try {
            block20: {
                try {
                    JMSEndpoint endpoint = null;
                    if (dest == null) {
                        String to;
                        Object destination = msgContext.getProperty("transport.jms.Destination");
                        if (destination == null && msgContext.getTo() != null && (to = msgContext.getTo().getAddress()) != null) {
                            JMSURLHelper url = new JMSURLHelper(to);
                            destination = url.getDestination();
                        }
                        if (destination == null) {
                            throw new AxisFault("noDestination");
                        }
                        endpoint = destination instanceof String ? connector.createEndpoint((String)destination) : connector.createEndpoint((Destination)destination);
                    } else {
                        endpoint = connector.createEndpoint(dest);
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    this.writeMessage(msgContext, out);
                    HashMap props = this.createSendProperties(msgContext);
                    props.put("contentType", this.getContentType(msgContext));
                    props.put("SOAPAction", this.getSOAPAction(msgContext));
                    if (waitForResponse) {
                        long timeout = 5000L;
                        if (msgContext.getProperty("transport.jms.timeoutTime") != null) {
                            timeout = (Long)msgContext.getProperty("transport.jms.timeoutTime");
                        }
                        byte[] response = endpoint.call(out.toByteArray(), timeout, props);
                        ByteArrayInputStream in = new ByteArrayInputStream(response);
                        msgContext.setProperty("TRANSPORT_IN", in);
                        break block20;
                    }
                    endpoint.send(out.toByteArray(), props);
                }
                catch (Exception e) {
                    throw new AxisFault("failedSend", e);
                }
            }
            Object var15_16 = null;
            if (connector != null) {
                JMSConnectorManager.getInstance().release(connector);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (connector != null) {
                JMSConnectorManager.getInstance().release(connector);
            }
            throw throwable;
        }
    }

    public void setupTransport(MessageContext context, String endpointAddr) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JMSTransport::invoke");
        }
        JMSConnector connector = null;
        HashMap connectorProperties = null;
        HashMap connectionFactoryProperties = null;
        JMSVendorAdapter vendorAdapter = null;
        JMSURLHelper jmsurl = null;
        String username = "";
        String password = "";
        if (endpointAddr != null) {
            try {
                jmsurl = new JMSURLHelper(endpointAddr);
                String vendorId = jmsurl.getVendor();
                if (vendorId == null) {
                    vendorId = "JNDI";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JMSTransport.invoke(): endpt=" + endpointAddr + ", vendor=" + vendorId));
                }
                if ((vendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter(vendorId)) == null) {
                    throw new AxisFault("cannotLoadAdapterClass:" + vendorId);
                }
                connectorProperties = vendorAdapter.getJMSConnectorProperties(jmsurl);
                connectionFactoryProperties = vendorAdapter.getJMSConnectionFactoryProperties(jmsurl);
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage("malformedURLException00"), (Throwable)e);
                throw new AxisFault(Messages.getMessage("malformedURLException00"), e);
            }
        }
        try {
            vendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter();
        }
        catch (Exception e) {
            throw new AxisFault("cannotLoadAdapterClass");
        }
        connectorProperties = this.params;
        connectionFactoryProperties = this.params;
        try {
            connector = JMSConnectorManager.getInstance().getConnector(connectorProperties, connectionFactoryProperties, username, password, vendorAdapter);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("cannotConnectError"), (Throwable)e);
            if (e instanceof AxisFault) {
                throw (AxisFault)e;
            }
            throw new AxisFault("cannotConnect", e);
        }
        context.setProperty("transport.jms.Connector", connector);
        context.setProperty("transport.jms.VendorAdapter", vendorAdapter);
        vendorAdapter.setupMessageContext(context, jmsurl);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JMSTransport::invoke");
        }
    }

    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JMSTransport::shutdown");
        }
        JMSSender.closeAllConnectors();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JMSTransport::shutdown");
        }
    }

    public void writeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope = msgContext.getEnvelope();
        OMElement outputMessage = envelope;
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                format.setDoOptimize(msgContext.isDoingMTOM());
                format.setCharSetEncoding(charSetEnc);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }

    public String getContentType(MessageContext msgCtx) {
        OMOutputFormat format = new OMOutputFormat();
        String soapActionString = this.getSOAPAction(msgCtx);
        String charSetEnc = (String)msgCtx.getProperty("CHARACTER_SET_ENCODING");
        if (charSetEnc != null) {
            format.setCharSetEncoding(charSetEnc);
        } else {
            OperationContext opctx = msgCtx.getOperationContext();
            if (opctx != null) {
                charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
            }
        }
        if (charSetEnc == null) {
            charSetEnc = "UTF-8";
        }
        format.setSOAP11(msgCtx.isSOAP11());
        format.setCharSetEncoding(charSetEnc);
        String encoding = format.getCharSetEncoding();
        String contentType = format.getContentType();
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (!msgCtx.isSOAP11() && soapActionString != null && !"".equals(soapActionString.trim())) {
            contentType = contentType + ";action=\"" + soapActionString + "\";";
        }
        return contentType;
    }

    private String getSOAPAction(MessageContext msgCtx) {
        String soapActionString = msgCtx.getSoapAction();
        if (soapActionString == null || soapActionString.length() == 0) {
            soapActionString = msgCtx.getWSAAction();
        }
        if (soapActionString == null) {
            soapActionString = "";
        }
        return soapActionString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JMSSender.closeAllConnectors();
            }
        });
    }
}

