/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.jms.JMSURLHelper;

public abstract class JMSVendorAdapter {
    public static final int SEND_ACTION = 0;
    public static final int CONNECT_ACTION = 1;
    public static final int SUBSCRIBE_ACTION = 2;
    public static final int RECEIVE_ACTION = 3;
    public static final int ON_EXCEPTION_ACTION = 4;

    public abstract void addVendorConnectionFactoryProperties(JMSURLHelper var1, HashMap var2);

    public void setupApplicationProperties(MessageContext context, JMSURLHelper jmsurl) {
        Map ctxProps;
        HashMap<String, String> appProps = new HashMap<String, String>();
        if (jmsurl != null && jmsurl.getApplicationProperties() != null) {
            Iterator itr = jmsurl.getApplicationProperties().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                appProps.put(name, jmsurl.getPropertyValue(name));
            }
        }
        if ((ctxProps = (Map)context.getProperty("transport.jms.msgProps")) != null) {
            appProps.putAll(ctxProps);
        }
        context.setProperty("transport.jms.msgProps", appProps);
    }

    public void setupMessageContext(MessageContext context, JMSURLHelper jmsurl) {
        String jmsurlDestination = null;
        if (jmsurl != null) {
            jmsurlDestination = jmsurl.getDestination();
        }
        if (jmsurlDestination != null) {
            context.setProperty("transport.jms.Destination", jmsurlDestination);
        }
        String delivMode = null;
        if (jmsurl != null) {
            delivMode = jmsurl.getPropertyValue("deliveryMode");
        }
        if (delivMode != null) {
            int mode = 1;
            if (delivMode.equalsIgnoreCase("Persistent")) {
                mode = 2;
            } else if (delivMode.equalsIgnoreCase("Nonpersistent")) {
                mode = 1;
            }
            context.setProperty("transport.jms.deliveryMode", new Integer(mode));
        }
        String prio = null;
        if (jmsurl != null) {
            prio = jmsurl.getPropertyValue("priority");
        }
        if (prio != null) {
            context.setProperty("transport.jms.priority", Integer.valueOf(prio));
        }
        String ttl = null;
        if (jmsurl != null) {
            ttl = jmsurl.getPropertyValue("ttl");
        }
        if (ttl != null) {
            context.setProperty("transport.jms.ttl", Long.valueOf(ttl));
        }
        this.setupApplicationProperties(context, jmsurl);
    }

    public HashMap getJMSConnectionFactoryProperties(JMSURLHelper jmsurl) {
        HashMap<String, Object> cfProps = new HashMap<String, Object>();
        cfProps.put("transport.jms.EndpointAddress", jmsurl);
        String domain = jmsurl.getPropertyValue("domain");
        if (domain != null) {
            cfProps.put("transport.jms.domain", domain);
        }
        this.addVendorConnectionFactoryProperties(jmsurl, cfProps);
        return cfProps;
    }

    public HashMap getJMSConnectorProperties(JMSURLHelper jmsurl) {
        String timeoutTime;
        String numSessions;
        String numRetries;
        String domain;
        String interactRetryInterval;
        String connectRetryInterval;
        HashMap<String, Object> connectorProps = new HashMap<String, Object>();
        connectorProps.put("transport.jms.EndpointAddress", jmsurl);
        String clientID = jmsurl.getPropertyValue("clientID");
        if (clientID != null) {
            connectorProps.put("transport.jms.clientID", clientID);
        }
        if ((connectRetryInterval = jmsurl.getPropertyValue("connectRetryInterval")) != null) {
            connectorProps.put("transport.jms.connectRetryInterval", connectRetryInterval);
        }
        if ((interactRetryInterval = jmsurl.getPropertyValue("interactRetryInterval")) != null) {
            connectorProps.put("transport.jms.interactRetryInterval", interactRetryInterval);
        }
        if ((domain = jmsurl.getPropertyValue("domain")) != null) {
            connectorProps.put("transport.jms.domain", domain);
        }
        if ((numRetries = jmsurl.getPropertyValue("numRetries")) != null) {
            connectorProps.put("transport.jms.numRetries", numRetries);
        }
        if ((numSessions = jmsurl.getPropertyValue("numSessions")) != null) {
            connectorProps.put("transport.jms.numSessions", numSessions);
        }
        if ((timeoutTime = jmsurl.getPropertyValue("timeoutTime")) != null) {
            connectorProps.put("transport.jms.timeoutTime", timeoutTime);
        }
        return connectorProps;
    }

    public Queue getQueue(QueueSession session, String name) throws Exception {
        return session.createQueue(name);
    }

    public abstract QueueConnectionFactory getQueueConnectionFactory(HashMap var1) throws Exception;

    public Topic getTopic(TopicSession session, String name) throws Exception {
        return session.createTopic(name);
    }

    public abstract TopicConnectionFactory getTopicConnectionFactory(HashMap var1) throws Exception;

    public String getVendorId() {
        int index;
        String name = this.getClass().getName();
        if (name.endsWith("VendorAdapter")) {
            index = name.lastIndexOf("VendorAdapter");
            name = name.substring(0, index);
        }
        if ((index = name.lastIndexOf(".")) > 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public abstract boolean isMatchingConnectionFactory(ConnectionFactory var1, JMSURLHelper var2, HashMap var3);

    public boolean isRecoverable(Throwable thrown, int action) {
        if (thrown instanceof RuntimeException || thrown instanceof Error || thrown instanceof JMSSecurityException || thrown instanceof InvalidDestinationException) {
            return false;
        }
        return action != 4;
    }

    public void setProperties(Message message, HashMap props) throws JMSException {
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)props.get(key);
            message.setStringProperty(key, value);
        }
    }
}

