/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.jms.BytesMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.om.OMException;
import org.apache.axis2.om.impl.llom.builder.StAXBuilder;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.SOAPProcessingException;
import org.apache.axis2.soap.impl.llom.builder.StAXSOAPModelBuilder;
import org.apache.axis2.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.SimpleJMSListener;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleJMSWorker
implements Runnable {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis2$transport$jms$SimpleJMSWorker == null ? (class$org$apache$axis2$transport$jms$SimpleJMSWorker = SimpleJMSWorker.class$("org.apache.axis2.transport.jms.SimpleJMSWorker")) : class$org$apache$axis2$transport$jms$SimpleJMSWorker).getName());
    private ConfigurationContext configurationContext;
    SimpleJMSListener listener;
    BytesMessage message;
    static /* synthetic */ Class class$org$apache$axis2$transport$jms$SimpleJMSWorker;

    public SimpleJMSWorker(ConfigurationContext configurationContext, SimpleJMSListener listener, BytesMessage message) {
        this.listener = listener;
        this.message = message;
        this.configurationContext = configurationContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processJMSRequest(MessageContext msgContext, InputStream in, String contentType) throws AxisFault {
        boolean soap11 = false;
        try {
            try {
                String charsetEncoding;
                msgContext.setServerSide(true);
                SOAPEnvelope envelope = null;
                StAXBuilder builder = null;
                if (contentType != null) {
                    if (contentType.indexOf("multipart/related") > -1) {
                        builder = TransportUtils.selectBuilderForMIME(msgContext, in, contentType);
                        envelope = (SOAPEnvelope)builder.getDocumentElement();
                    } else {
                        XMLStreamReader xmlreader;
                        if (TransportUtils.getCharSetEncoding(contentType) == null) {
                            xmlreader = XMLInputFactory.newInstance().createXMLStreamReader(in, "UTF-8");
                            msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                        } else {
                            String charSetEnc = TransportUtils.getCharSetEncoding(contentType);
                            xmlreader = XMLInputFactory.newInstance().createXMLStreamReader(in, charSetEnc);
                            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
                        }
                        if (contentType.indexOf("application/soap+xml") > -1) {
                            soap11 = false;
                            builder = new StAXSOAPModelBuilder(xmlreader, "http://www.w3.org/2003/05/soap-envelope");
                            envelope = (SOAPEnvelope)builder.getDocumentElement();
                        } else if (contentType.indexOf("text/xml") > -1) {
                            soap11 = true;
                            builder = new StAXSOAPModelBuilder(xmlreader, "http://schemas.xmlsoap.org/soap/envelope/");
                            envelope = (SOAPEnvelope)builder.getDocumentElement();
                        }
                    }
                }
                if ((charsetEncoding = builder.getDocument().getCharsetEncoding()) != null && !"".equals(charsetEncoding) && !((String)msgContext.getProperty("CHARACTER_SET_ENCODING")).equalsIgnoreCase(charsetEncoding)) {
                    String faultCode;
                    if ("http://www.w3.org/2003/05/soap-envelope".equals(envelope.getNamespace().getName())) {
                        faultCode = "Sender";
                        throw new AxisFault("Character Set Encoding from transport information do not match with character set encoding in the received SOAP message", faultCode);
                    }
                    faultCode = "Client";
                    throw new AxisFault("Character Set Encoding from transport information do not match with character set encoding in the received SOAP message", faultCode);
                }
                msgContext.setEnvelope(envelope);
                AxisEngine engine = new AxisEngine(msgContext.getConfigurationContext());
                if (envelope.getBody().hasFault()) {
                    engine.receiveFault(msgContext);
                }
                engine.receive(msgContext);
            }
            catch (SOAPProcessingException e) {
                throw new AxisFault(e);
            }
            catch (AxisFault e) {
                throw e;
            }
            catch (OMException e) {
                throw new AxisFault(e);
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw new AxisFault(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new AxisFault(e);
            }
            Object var9_14 = null;
            if (msgContext.getEnvelope() != null) return;
            if (soap11) return;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (msgContext.getEnvelope() != null) throw throwable;
            if (soap11) throw throwable;
            msgContext.setEnvelope(new SOAP12Factory().createSOAPEnvelope());
            throw throwable;
        }
        msgContext.setEnvelope(new SOAP12Factory().createSOAPEnvelope());
    }

    public void run() {
        MessageContext msgContext;
        ByteArrayInputStream in = null;
        try {
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int bytesRead = this.message.readBytes(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                bytesRead = this.message.readBytes(buffer);
            }
            in = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            e.printStackTrace();
            return;
        }
        String contentType = null;
        try {
            contentType = this.message.getStringProperty("contentType");
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            e.printStackTrace();
            return;
        }
        String soapAction = null;
        try {
            soapAction = this.message.getStringProperty("SOAPAction");
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            e.printStackTrace();
            return;
        }
        try {
            TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn(new QName("jms"));
            TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut(new QName("jms"));
            msgContext = new MessageContext();
            msgContext.setConfigurationContext(this.configurationContext);
            msgContext.setTransportIn(transportIn);
            msgContext.setTransportOut(transportOut);
            msgContext.setProperty("OutTransportInfo", new JMSOutTransportInfo(this.message.getJMSReplyTo(), this.listener.getProperties()));
            msgContext.setTransportOut(transportOut);
            msgContext.setServerSide(true);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            e.printStackTrace();
            return;
        }
        msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
        if (soapAction != null) {
            msgContext.setSoapAction(soapAction);
        }
        try {
            SimpleJMSWorker.processJMSRequest(msgContext, in, contentType);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            e.printStackTrace();
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

