/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.axis2.AxisFault;
import org.apache.axis2.i18n.Messages;

public class EmailReceiver {
    private String host;
    private Folder inbox;
    private String password;
    private String popPort;
    private Store store;
    private String user;

    public EmailReceiver(String user, String host, String popPort, String password) throws AxisFault {
        this.user = user;
        this.host = host;
        this.popPort = popPort;
        this.password = password;
        if (this.user == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "User"));
        }
        if (this.host == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "Host"));
        }
        if (this.popPort == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "port"));
        }
        if (this.password == null) {
            throw new AxisFault(Messages.getMessage("canNotBeNull", "Password"));
        }
    }

    public void connect() throws AxisFault {
        try {
            final PasswordAuthentication authentication = new PasswordAuthentication(this.user, this.password);
            Properties props = new Properties();
            props.put("mail.user", this.user);
            props.put("mail.host", this.host);
            props.put("mail.store.protocol", "pop3");
            props.put("mail.transport.protocol", "smtp");
            props.put("mail.pop3.port", this.popPort);
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return authentication;
                }
            });
            this.store = session.getStore();
            this.store.connect();
            Folder root = this.store.getDefaultFolder();
            this.inbox = root.getFolder("inbox");
        }
        catch (NoSuchProviderException e) {
            throw new AxisFault(e);
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }

    public void disconnect() throws AxisFault {
        try {
            this.inbox.close(true);
            this.store.close();
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }

    public Message[] receive() throws AxisFault {
        try {
            this.inbox.open(2);
            Message[] msgs = this.inbox.getMessages();
            if (msgs.length == 0) {
                return null;
            }
            return msgs;
        }
        catch (NoSuchProviderException e) {
            throw new AxisFault(e);
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }
}

