/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.impl.llom.builder.StAXSOAPModelBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailWorker
implements Runnable {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis2$transport$mail$MailWorker == null ? (class$org$apache$axis2$transport$mail$MailWorker = MailWorker.class$("org.apache.axis2.transport.mail.MailWorker")) : class$org$apache$axis2$transport$mail$MailWorker).getName());
    private ConfigurationContext configContext = null;
    private Properties prop = new Properties();
    private MimeMessage mimeMessage;
    static /* synthetic */ Class class$org$apache$axis2$transport$mail$MailWorker;

    public MailWorker(MimeMessage mimeMessage, ConfigurationContext reg) {
        this.mimeMessage = mimeMessage;
        this.configContext = reg;
    }

    public void run() {
        block14: {
            AxisEngine engine = new AxisEngine(this.configContext);
            MessageContext msgContext = null;
            try {
                TransportInDescription transportIn = this.configContext.getAxisConfiguration().getTransportIn(new QName("mail"));
                TransportOutDescription transportOut = this.configContext.getAxisConfiguration().getTransportOut(new QName("mail"));
                if (transportIn != null && transportOut != null) {
                    String replyTo;
                    msgContext = new MessageContext();
                    msgContext.setConfigurationContext(this.configContext);
                    msgContext.setTransportIn(transportIn);
                    msgContext.setTransportOut(transportOut);
                    msgContext.setServerSide(true);
                    msgContext.setProperty("transport.mail.contenttype", this.mimeMessage.getContentType());
                    msgContext.setProperty("CHARACTER_SET_ENCODING", this.mimeMessage.getEncoding());
                    String soapAction = this.getMailHeader("transport.mail.soapaction");
                    msgContext.setWSAAction(soapAction);
                    msgContext.setSoapAction(soapAction);
                    InternetAddress[] recepainets = (InternetAddress[])this.mimeMessage.getAllRecipients();
                    if (recepainets == null || recepainets.length <= 0) {
                        throw new AxisFault(Messages.getMessage("noRecep4Email"));
                    }
                    String emailAddress = recepainets[0].getAddress();
                    String emailSubject = this.mimeMessage.getSubject();
                    EndpointReference to = new EndpointReference(emailAddress + "/" + (emailSubject != null ? emailSubject : ""));
                    InternetAddress[] replyToAs = (InternetAddress[])this.mimeMessage.getAllRecipients();
                    if (replyToAs != null && replyToAs.length > 0 && (replyTo = replyToAs[0].getAddress()) != null) {
                        msgContext.setReplyTo(new EndpointReference(replyTo));
                    }
                    String message = this.mimeMessage.getContent().toString();
                    ByteArrayInputStream bais = new ByteArrayInputStream(message.getBytes());
                    XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(bais);
                    String soapNamespaceURI = "";
                    if (this.mimeMessage.getContentType().indexOf("application/soap+xml") > -1) {
                        soapNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
                    } else if (this.mimeMessage.getContentType().indexOf("text/xml") > -1) {
                        soapNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
                    }
                    StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(reader, soapNamespaceURI);
                    SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
                    msgContext.setEnvelope(envelope);
                    if (envelope.getBody().hasFault()) {
                        engine.receiveFault(msgContext);
                    } else {
                        engine.receive(msgContext);
                    }
                    break block14;
                }
                throw new AxisFault(Messages.getMessage("unknownTransport", "mail"));
            }
            catch (Exception e) {
                try {
                    if (msgContext != null) {
                        MessageContext faultContext = engine.createFaultMessageContext(msgContext, e);
                        engine.sendFault(faultContext);
                    } else {
                        log.error((Object)e);
                    }
                }
                catch (AxisFault e1) {
                    log.error((Object)e);
                }
            }
        }
    }

    private String getMailHeader(String headerName) throws AxisFault {
        try {
            String[] values = this.mimeMessage.getHeader(headerName);
            if (values != null) {
                return values[0];
            }
            return null;
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

