/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail.server;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.soap.SOAPEnvelope;
import org.apache.axis2.soap.impl.llom.builder.StAXSOAPModelBuilder;
import org.apache.axis2.transport.mail.server.Storage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailSorter {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$axis2$transport$mail$server$MailSorter == null ? (class$org$apache$axis2$transport$mail$server$MailSorter = MailSorter.class$("org.apache.axis2.transport.mail.server.MailSorter")) : class$org$apache$axis2$transport$mail$server$MailSorter).getName());
    Storage st = null;
    private ArrayList sUsers = new ArrayList();
    private ConfigurationContext configurationContext = null;
    private boolean actAsMailet = false;
    static /* synthetic */ Class class$org$apache$axis2$transport$mail$server$MailSorter;

    public MailSorter(Storage st, ConfigurationContext configurationContext) {
        this.st = st;
        this.sUsers.add("axis2-server@localhost");
        this.sUsers.add("axis2-server@127.0.0.1");
        if (configurationContext == null) {
            this.actAsMailet = false;
        } else {
            this.configurationContext = configurationContext;
            this.actAsMailet = true;
        }
    }

    public void processMail(ConfigurationContext confContext, MimeMessage mimeMessage) {
        AxisEngine engine = new AxisEngine(confContext);
        MessageContext msgContext = null;
        try {
            String recepainets;
            String replyTo;
            msgContext = new MessageContext();
            msgContext.setConfigurationContext(confContext);
            msgContext.setTransportIn(confContext.getAxisConfiguration().getTransportIn(new QName("mail")));
            msgContext.setTransportOut(confContext.getAxisConfiguration().getTransportOut(new QName("mail")));
            msgContext.setServerSide(true);
            msgContext.setProperty("transport.mail.contenttype", mimeMessage.getContentType());
            msgContext.setWSAAction(this.getMailHeader("transport.mail.soapaction", mimeMessage));
            String serviceURL = mimeMessage.getSubject();
            if (serviceURL == null) {
                serviceURL = "";
            }
            if ((replyTo = ((InternetAddress)mimeMessage.getReplyTo()[0]).getAddress()) != null) {
                msgContext.setReplyTo(new EndpointReference(replyTo));
            }
            if ((recepainets = ((InternetAddress)mimeMessage.getAllRecipients()[0]).getAddress()) != null) {
                msgContext.setTo(new EndpointReference(recepainets + "/" + serviceURL));
            }
            String message = mimeMessage.getContent().toString();
            log.info((Object)("message[" + message + "]"));
            ByteArrayInputStream bais = new ByteArrayInputStream(message.getBytes());
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(bais);
            String soapNamespaceURI = "";
            if (mimeMessage.getContentType().indexOf("application/soap+xml") > -1) {
                soapNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
            } else if (mimeMessage.getContentType().indexOf("text/xml") > -1) {
                soapNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
            }
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(reader, soapNamespaceURI);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            msgContext.setEnvelope(envelope);
            if (envelope.getBody().hasFault()) {
                engine.receiveFault(msgContext);
            } else {
                engine.receive(msgContext);
            }
        }
        catch (Exception e) {
            try {
                if (msgContext != null) {
                    MessageContext faultContext = engine.createFaultMessageContext(msgContext, e);
                    engine.sendFault(faultContext);
                }
            }
            catch (Exception e1) {
                log.error((Object)e);
            }
        }
    }

    public void sort(String user, MimeMessage msg) {
        if (this.actAsMailet) {
            if (this.sUsers.contains(user)) {
                this.processMail(this.configurationContext, msg);
            } else {
                this.st.addMail(user, msg);
            }
        } else {
            this.st.addMail(user, msg);
        }
    }

    private String getMailHeader(String headerName, MimeMessage mimeMessage) throws AxisFault {
        try {
            String[] values = mimeMessage.getHeader(headerName);
            if (values != null) {
                return values[0];
            }
            return null;
        }
        catch (MessagingException e) {
            throw new AxisFault(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

