/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.mail.server.SMTPWorker;
import org.apache.axis2.transport.mail.server.Storage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMTPServer
extends Thread {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean actAsMailet = false;
    private boolean running = false;
    private ConfigurationContext configurationContext;
    private int port;
    private ServerSocket ss;
    private Storage st;

    public SMTPServer(Storage st, int port) {
        this.st = st;
        this.port = port;
        this.actAsMailet = false;
    }

    public SMTPServer(Storage st, ConfigurationContext configurationContext, int port) {
        this.st = st;
        this.configurationContext = configurationContext;
        this.port = port;
        this.actAsMailet = true;
    }

    public void run() {
        this.runServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runServer() {
        try {
            SMTPServer sMTPServer = this;
            synchronized (sMTPServer) {
                this.running = true;
                this.ss = new ServerSocket(this.port);
                this.log.info((Object)("SMTP Server started on port " + this.port));
            }
        }
        catch (IOException ex) {
            this.log.info((Object)ex.getMessage());
        }
        while (this.running) {
            try {
                Socket socket = this.ss.accept();
                SMTPWorker thread = null;
                thread = this.actAsMailet ? new SMTPWorker(socket, this.st, this.configurationContext) : new SMTPWorker(socket, this.st);
                thread.start();
            }
            catch (IOException ex) {
                if (!this.running) continue;
                this.log.info((Object)ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() throws AxisFault {
        try {
            SMTPServer sMTPServer = this;
            synchronized (sMTPServer) {
                this.running = false;
                this.ss.close();
            }
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }
}

