/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ListenerManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.tcp.TCPWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPServer
extends TransportListener
implements Runnable {
    private int port = 8000;
    private boolean started = false;
    protected Log log = LogFactory.getLog((String)(class$org$apache$axis2$transport$http$SimpleHTTPServer == null ? (class$org$apache$axis2$transport$http$SimpleHTTPServer = TCPServer.class$("org.apache.axis2.transport.http.SimpleHTTPServer")) : class$org$apache$axis2$transport$http$SimpleHTTPServer).getName());
    private ConfigurationContext configContext;
    private ServerSocket serversocket;
    static /* synthetic */ Class class$org$apache$axis2$transport$http$SimpleHTTPServer;

    public TCPServer() {
    }

    public TCPServer(int port, ConfigurationContext configContext) throws AxisFault {
        try {
            this.configContext = configContext;
            this.serversocket = new ServerSocket(port);
        }
        catch (IOException e1) {
            throw new AxisFault(e1);
        }
    }

    public TCPServer(int port, String dir) throws AxisFault {
        try {
            ConfigurationContextFactory erfac = new ConfigurationContextFactory();
            this.configContext = erfac.createConfigurationContextFromFileSystem(dir);
            Thread.sleep(3000L);
            this.serversocket = new ServerSocket(port);
        }
        catch (DeploymentException e1) {
            throw new AxisFault(e1);
        }
        catch (InterruptedException e1) {
            throw new AxisFault(e1);
        }
        catch (IOException e1) {
            throw new AxisFault(e1);
        }
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        this.configContext = axisConf;
        Parameter param = transprtIn.getParameter("port");
        if (param != null) {
            this.port = Integer.parseInt((String)param.getValue());
        }
    }

    public static void main(String[] args) throws AxisFault, NumberFormatException {
        if (args.length != 2) {
            System.out.println("TCPServer repositoryLocation port");
        } else {
            File repository = new File(args[0]);
            if (!repository.exists()) {
                System.out.print("Repository file does not exists .. initializing repository");
            }
            TCPServer tcpServer = new TCPServer(Integer.parseInt(args[1]), repository.getAbsolutePath());
            System.out.println("[Axis2] Using the Repository " + repository.getAbsolutePath());
            System.out.println("[Axis2] Starting the TCP Server on port " + args[1]);
            tcpServer.start();
        }
    }

    public void run() {
        while (this.started) {
            Socket socket = null;
            try {
                socket = this.serversocket.accept();
            }
            catch (InterruptedIOException iie) {
            }
            catch (Exception e) {
                this.log.debug((Object)e);
                break;
            }
            if (socket == null) continue;
            this.configContext.getThreadPool().execute(new TCPWorker(this.configContext, socket));
        }
    }

    public synchronized void start() throws AxisFault {
        if (this.serversocket == null) {
            this.serversocket = ListenerManager.openSocket(this.port);
        }
        this.started = true;
        this.configContext.getThreadPool().execute(this);
    }

    public void stop() throws AxisFault {
        try {
            this.serversocket.close();
            this.started = false;
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configContext;
    }

    public EndpointReference getReplyToEPR(String serviceName) throws AxisFault {
        return new EndpointReference("tcp://127.0.0.1:" + this.serversocket.getLocalPort() + "/axis/services/" + serviceName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

