/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.AbstractTransportSender;
import org.apache.axis2.util.URL;

public class TCPTransportSender
extends AbstractTransportSender {
    private static final long serialVersionUID = -6780125098288186598L;
    protected Writer out;
    private Socket socket;

    public void cleanUp(MessageContext msgContext) throws AxisFault {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void finalizeSendWithOutputStreamFromIncomingConnection(MessageContext msgContext, OutputStream out) {
    }

    public void finalizeSendWithToAddress(MessageContext msgContext, OutputStream out) throws AxisFault {
        try {
            this.socket.shutdownOutput();
            msgContext.setProperty("TRANSPORT_IN", this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    protected OutputStream openTheConnection(EndpointReference toURL, MessageContext msgContext) throws AxisFault {
        if (toURL != null) {
            try {
                URL url = new URL(toURL.getAddress());
                InetSocketAddress add = new InetSocketAddress(url.getHost(), url.getPort() == -1 ? 80 : url.getPort());
                this.socket = new Socket();
                this.socket.connect(add);
                return this.socket.getOutputStream();
            }
            catch (MalformedURLException e) {
                throw new AxisFault(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new AxisFault(e.getMessage(), e);
            }
        }
        throw new AxisFault(Messages.getMessage("canNotBeNull", "Can not Be Null"));
    }

    public OutputStream startSendWithOutputStreamFromIncomingConnection(MessageContext msgContext, OutputStream out) throws AxisFault {
        return out;
    }

    public OutputStream startSendWithToAddress(MessageContext msgContext, OutputStream out) {
        return out;
    }

    protected void writeTransportHeaders(Writer out, URL url, MessageContext msgContext, int contentLength) throws IOException {
    }
}

