/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;

public class JavaUtils {
    static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final char keywordPrefix = '_';

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public static String makeNonJavaKeyword(String keyword) {
        return '_' + keyword;
    }

    public static String xmlNameToJava(String name) {
        int i;
        if (name == null || name.equals("")) {
            return name;
        }
        char[] nameArray = name.toCharArray();
        int nameLen = name.length();
        StringBuffer result = new StringBuffer(nameLen);
        boolean wordStart = false;
        for (i = 0; i < nameLen && (JavaUtils.isPunctuation(nameArray[i]) || !Character.isJavaIdentifierStart(nameArray[i])); ++i) {
        }
        if (i < nameLen) {
            result.append(nameArray[i]);
            wordStart = !Character.isLetter(nameArray[i]) && nameArray[i] != "_".charAt(0);
        } else if (Character.isJavaIdentifierPart(nameArray[0])) {
            result.append("_" + nameArray[0]);
        } else {
            result.append("_" + nameArray.length);
        }
        ++i;
        while (i < nameLen) {
            char c = nameArray[i];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                wordStart = true;
            } else {
                if (wordStart && Character.isLowerCase(c)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                wordStart = !Character.isLetter(c) && c != "_".charAt(0);
            }
            ++i;
        }
        String newName = result.toString();
        if (JavaUtils.isJavaKeyword(newName)) {
            newName = JavaUtils.makeNonJavaKeyword(newName);
        }
        return newName;
    }

    public static String capitalizeFirstChar(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        char start = name.charAt(0);
        if (Character.isLowerCase(start)) {
            start = Character.toUpperCase(start);
            return start + name.substring(1);
        }
        return name;
    }
}

