/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisDescWSDLComponentFactory;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.ws.policy.PolicyReference;
import org.apache.wsdl.Component;
import org.apache.wsdl.WSDLBinding;
import org.apache.wsdl.WSDLBindingOperation;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.WSDLEndpoint;
import org.apache.wsdl.WSDLExtensibilityAttribute;
import org.apache.wsdl.WSDLInterface;
import org.apache.wsdl.WSDLOperation;
import org.apache.wsdl.WSDLService;
import org.apache.wsdl.extensions.ExtensionConstants;
import org.apache.wsdl.extensions.PolicyExtensibilityElement;
import org.apache.wsdl.extensions.impl.ExtensionFactoryImpl;
import org.apache.wsdl.impl.WSDLProcessingException;

public class PolicyUtil {
    public static void populatePolicy(WSDLDescription description, AxisService axisService) {
        WSDLService wsdlService = description.getService(new QName(axisService.getName()));
        PolicyUtil.populatePolicy(description, wsdlService, axisService);
    }

    private static void populatePolicy(WSDLDescription description, WSDLService wsdlService, AxisService axisService) {
        ArrayList policyList;
        AxisServiceGroup axisServiceGroup = null;
        AxisConfiguration axisConfiguration = null;
        axisServiceGroup = axisService.getParent();
        if (axisServiceGroup == null) {
            axisConfiguration = axisServiceGroup.getParent();
        }
        PolicyInclude servicePolicyInclude = axisService.getPolicyInclude();
        if (axisConfiguration != null) {
            policyList = axisConfiguration.getPolicyInclude().getPolicyElements(1);
            PolicyUtil.addPolicyAsExtElements(description, policyList, wsdlService, servicePolicyInclude);
        }
        policyList = servicePolicyInclude.getPolicyElements(3);
        PolicyUtil.addPolicyAsExtElements(description, policyList, wsdlService, servicePolicyInclude);
        Iterator wsdlEndpoints = wsdlService.getEndpoints().values().iterator();
        if (!wsdlEndpoints.hasNext()) {
            throw new WSDLProcessingException("should at least one endpoints");
        }
        WSDLEndpoint wsdlEndpoint = (WSDLEndpoint)wsdlEndpoints.next();
        PolicyUtil.populatePolicy(description, wsdlEndpoint, axisService);
    }

    private static void populatePolicy(WSDLDescription description, WSDLEndpoint wsdlEndpoint, AxisService axisService) {
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        ArrayList policyList = policyInclude.getPolicyElements(4);
        PolicyUtil.addPolicyAsExtElements(description, policyList, wsdlEndpoint, policyInclude);
        WSDLBinding wsdlBinding = wsdlEndpoint.getBinding();
        PolicyUtil.populatePolicy(description, wsdlBinding, axisService);
        WSDLInterface wsdlInterface = wsdlBinding.getBoundInterface();
        PolicyUtil.populatePolicy(description, wsdlInterface, axisService);
    }

    private static void populatePolicy(WSDLDescription description, WSDLInterface wsdlInterface, AxisService axisService) {
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        ArrayList policyList = policyInclude.getPolicyElements(5);
        PolicyUtil.addPolicyAsExtAttributes(description, policyList, wsdlInterface, policyInclude);
        Iterator wsdlOperations = wsdlInterface.getOperations().values().iterator();
        while (wsdlOperations.hasNext()) {
            WSDLOperation wsdlOperation = (WSDLOperation)wsdlOperations.next();
            PolicyUtil.populatePolicy(description, wsdlOperation, axisService.getOperation(wsdlOperation.getName()));
        }
    }

    private static void populatePolicy(WSDLDescription description, WSDLOperation wsdlOperation, AxisOperation axisOperation) {
        PolicyInclude policyInclude = axisOperation.getPolicyInclude();
        ArrayList policyList = policyInclude.getPolicyElements(7);
        PolicyUtil.addPolicyAsExtElements(description, policyList, wsdlOperation, policyInclude);
        if ("http://www.w3.org/2004/08/wsdl/in-only".equals(axisOperation.getMessageExchangePattern())) {
            AxisMessage input = axisOperation.getMessage("In");
            PolicyInclude policyInclude2 = input.getPolicyInclude();
            ArrayList policyList2 = policyInclude2.getPolicyElements(9);
            PolicyUtil.addPolicyAsExtAttributes(description, policyList2, wsdlOperation.getInputMessage(), policyInclude2);
        } else if ("http://www.w3.org/2004/08/wsdl/in-out".equals(axisOperation.getMessageExchangePattern())) {
            AxisMessage input = axisOperation.getMessage("In");
            PolicyInclude policyInclude2 = input.getPolicyInclude();
            ArrayList policyList2 = policyInclude2.getPolicyElements(9);
            PolicyUtil.addPolicyAsExtAttributes(description, policyList2, wsdlOperation.getInputMessage(), policyInclude2);
            AxisMessage output = axisOperation.getMessage("Out");
            policyInclude2 = output.getPolicyInclude();
            policyList2 = policyInclude2.getPolicyElements(10);
            PolicyUtil.addPolicyAsExtAttributes(description, policyList2, wsdlOperation.getOutputMessage(), policyInclude2);
        }
    }

    private static void populatePolicy(WSDLDescription description, WSDLBinding wsdlBinding, AxisService axisService) {
        PolicyInclude policyInclude = axisService.getPolicyInclude();
        ArrayList policyList = policyInclude.getPolicyElements(2);
        PolicyUtil.addPolicyAsExtElements(description, policyList, wsdlBinding, policyInclude);
        policyList = policyInclude.getPolicyElements(6);
        PolicyUtil.addPolicyAsExtElements(description, policyList, wsdlBinding, policyInclude);
        Iterator wsdlOperations = wsdlBinding.getBindingOperations().values().iterator();
        while (wsdlOperations.hasNext()) {
            WSDLBindingOperation wsdlBindingOperation = (WSDLBindingOperation)wsdlOperations.next();
            PolicyUtil.populatePolicy(description, wsdlBindingOperation, axisService.getOperation(wsdlBindingOperation.getName()));
        }
    }

    private static void populatePolicy(WSDLDescription description, WSDLBindingOperation wsdlBindingOperation, AxisOperation axisOperation) {
        PolicyInclude policyInclude = axisOperation.getPolicyInclude();
        ArrayList policyList = policyInclude.getPolicyElements(8);
        PolicyUtil.addPolicyAsExtElements(description, policyList, wsdlBindingOperation, policyInclude);
        policyList = policyInclude.getPolicyElements(14);
        PolicyUtil.addPolicyAsExtElements(description, policyList, wsdlBindingOperation, policyInclude);
        if ("http://www.w3.org/2004/08/wsdl/in-only".equals(axisOperation.getMessageExchangePattern())) {
            AxisMessage input = axisOperation.getMessage("In");
            PolicyInclude policyInclude2 = input.getPolicyInclude();
            ArrayList policyList2 = policyInclude2.getPolicyElements(9);
            PolicyUtil.addPolicyAsExtElements(description, policyList2, wsdlBindingOperation.getInput(), policyInclude2);
            policyList2 = policyInclude2.getPolicyElements(15);
            PolicyUtil.addPolicyAsExtElements(description, policyList2, wsdlBindingOperation.getInput(), policyInclude2);
        } else if ("http://www.w3.org/2004/08/wsdl/in-out".equals(axisOperation.getMessageExchangePattern())) {
            AxisMessage input = axisOperation.getMessage("In");
            PolicyInclude policyInclude2 = input.getPolicyInclude();
            ArrayList policyList2 = policyInclude2.getPolicyElements(9);
            PolicyUtil.addPolicyAsExtElements(description, policyList2, wsdlBindingOperation.getInput(), policyInclude2);
            policyList2 = policyInclude2.getPolicyElements(15);
            PolicyUtil.addPolicyAsExtElements(description, policyList2, wsdlBindingOperation.getInput(), policyInclude2);
            AxisMessage output = axisOperation.getMessage("Out");
            policyInclude2 = output.getPolicyInclude();
            policyList2 = policyInclude2.getPolicyElements(10);
            PolicyUtil.addPolicyAsExtElements(description, policyList2, wsdlBindingOperation.getOutput(), policyInclude2);
            policyList2 = policyInclude2.getPolicyElements(15);
            PolicyUtil.addPolicyAsExtElements(description, policyList2, wsdlBindingOperation.getInput(), policyInclude2);
        }
    }

    private static PolicyExtensibilityElement getExtensibilityElement(Object policyElement) {
        PolicyExtensibilityElement element = (PolicyExtensibilityElement)new ExtensionFactoryImpl().getExtensionElement(ExtensionConstants.POLICY);
        element.setPolicyElement(policyElement);
        return element;
    }

    private static WSDLExtensibilityAttribute getExtensibilitiyAttribute(PolicyReference policyReference) {
        WSDLExtensibilityAttribute extensibilityAttribute = new AxisDescWSDLComponentFactory().createWSDLExtensibilityAttribute();
        extensibilityAttribute.setKey(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "PolicyURIs"));
        extensibilityAttribute.setValue(new QName(policyReference.getPolicyURIString()));
        return extensibilityAttribute;
    }

    private static void addPolicyAsExtElements(WSDLDescription description, List policyList, Component component, PolicyInclude policyInclude) {
        Iterator policyElementIterator = policyList.iterator();
        while (policyElementIterator.hasNext()) {
            Object policyElement = policyElementIterator.next();
            if (policyElement instanceof PolicyReference) {
                String policyURIString = ((PolicyReference)policyElement).getPolicyURIString();
                description.addExtensibilityElement(PolicyUtil.getExtensibilityElement(policyInclude.getPolicy(policyURIString)));
            }
            component.addExtensibilityElement(PolicyUtil.getExtensibilityElement(policyElement));
        }
    }

    private static void addPolicyAsExtAttributes(WSDLDescription description, List policyList, Component component, PolicyInclude policyInclude) {
        Iterator policyElementIterator = policyList.iterator();
        while (policyElementIterator.hasNext()) {
            Object policyElement = policyElementIterator.next();
            if (!(policyElement instanceof PolicyReference)) continue;
            String policyURIString = ((PolicyReference)policyElement).getPolicyURIString();
            component.addExtensibleAttributes(PolicyUtil.getExtensibilitiyAttribute((PolicyReference)policyElement));
            description.addExtensibilityElement(PolicyUtil.getExtensibilityElement(policyInclude.getPolicy(policyURIString)));
        }
    }
}

