/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.ModuleDescription;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterImpl;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.receivers.RawXMLINOutMessageReceiver;
import org.apache.axis2.util.UUIDGenerator;

public class Utils {
    public static void addHandler(Flow flow, Handler handler, String phaseName) {
        HandlerDescription handlerDesc = new HandlerDescription();
        PhaseRule rule = new PhaseRule(phaseName);
        handlerDesc.setRules(rule);
        handler.init(handlerDesc);
        handlerDesc.setHandler(handler);
        flow.addHandler(handlerDesc);
    }

    public static MessageContext createOutMessageContext(MessageContext inMessageContext) {
        MessageContext newmsgCtx = new MessageContext();
        newmsgCtx.setConfigurationContext(inMessageContext.getConfigurationContext());
        newmsgCtx.setSessionContext(inMessageContext.getSessionContext());
        newmsgCtx.setTransportIn(inMessageContext.getTransportIn());
        newmsgCtx.setTransportOut(inMessageContext.getTransportOut());
        Options oldOptions = inMessageContext.getOptions();
        newmsgCtx.setMessageID(UUIDGenerator.getUUID());
        newmsgCtx.setTo(oldOptions.getReplyTo());
        newmsgCtx.setFaultTo(oldOptions.getFaultTo());
        newmsgCtx.setFrom(oldOptions.getTo());
        newmsgCtx.setRelatesTo(new RelatesTo(oldOptions.getMessageId(), "wsa:Reply"));
        newmsgCtx.setWSAAction(oldOptions.getAction());
        newmsgCtx.setOperationContext(inMessageContext.getOperationContext());
        newmsgCtx.setServiceContext(inMessageContext.getServiceContext());
        newmsgCtx.setProperty("TRANSPORT_OUT", inMessageContext.getProperty("TRANSPORT_OUT"));
        newmsgCtx.setProperty("OutTransportInfo", inMessageContext.getProperty("OutTransportInfo"));
        newmsgCtx.setProperty("CHARACTER_SET_ENCODING", inMessageContext.getProperty("CHARACTER_SET_ENCODING"));
        newmsgCtx.setDoingREST(inMessageContext.isDoingREST());
        newmsgCtx.setDoingMTOM(inMessageContext.isDoingMTOM());
        newmsgCtx.setServerSide(inMessageContext.isServerSide());
        newmsgCtx.setServiceGroupContextId(inMessageContext.getServiceGroupContextId());
        return newmsgCtx;
    }

    public static AxisService createSimpleService(QName serviceName, String className, QName opName) throws AxisFault {
        return Utils.createSimpleService(serviceName, new RawXMLINOutMessageReceiver(), className, opName);
    }

    public static AxisService createSimpleServiceforClient(QName serviceName, String className, QName opName) throws AxisFault {
        return Utils.createSimpleServiceforClient(serviceName, new RawXMLINOutMessageReceiver(), className, opName);
    }

    public static AxisService createSimpleService(QName serviceName, MessageReceiver messageReceiver, String className, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Thread.currentThread().getContextClassLoader());
        service.addParameter(new ParameterImpl("ServiceClass", className));
        InOutAxisOperation axisOp = new InOutAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        return service;
    }

    public static AxisService createSimpleServiceforClient(QName serviceName, MessageReceiver messageReceiver, String className, QName opName) throws AxisFault {
        AxisService service = new AxisService(serviceName.getLocalPart());
        service.setClassLoader(Thread.currentThread().getContextClassLoader());
        service.addParameter(new ParameterImpl("ServiceClass", className));
        OutInAxisOperation axisOp = new OutInAxisOperation(opName);
        axisOp.setMessageReceiver(messageReceiver);
        axisOp.setStyle("rpc");
        service.addOperation(axisOp);
        return service;
    }

    public static void extractServiceGroupAndServiceInfo(String filePart, MessageContext messageContext) {
        String[] values = Utils.parseRequestURLForServiceAndOperation(filePart);
        String serviceNameAndGroup = values[0];
        if (serviceNameAndGroup != null) {
            String[] serviceNameAndGroupStrings = serviceNameAndGroup.split(":");
            AxisConfiguration registry = messageContext.getConfigurationContext().getAxisConfiguration();
            if (serviceNameAndGroupStrings[0] != null) {
                AxisServiceGroup axisServiceGroup = registry.getServiceGroup(serviceNameAndGroupStrings[0]);
                String serviceNameStr = "";
                if (serviceNameAndGroupStrings.length == 1) {
                    serviceNameStr = serviceNameAndGroupStrings[0];
                }
                AxisService axisService = registry.getService(serviceNameStr);
                if (axisServiceGroup != null && axisService != null) {
                    messageContext.setAxisServiceGroup(axisServiceGroup);
                    messageContext.setAxisService(axisService);
                }
            }
        }
    }

    public static ServiceContext fillContextInformation(AxisOperation axisOperation, AxisService axisService, ConfigurationContext configurationContext) {
        return Utils.fillServiceContextAndServiceGroupContext(axisService, configurationContext);
    }

    private static ServiceContext fillServiceContextAndServiceGroupContext(AxisService axisService, ConfigurationContext configurationContext) {
        String serviceGroupContextId = UUIDGenerator.getUUID();
        ServiceGroupContext serviceGroupContext = new ServiceGroupContext(configurationContext, axisService.getParent());
        serviceGroupContext.setId(serviceGroupContextId);
        configurationContext.registerServiceGroupContext(serviceGroupContext);
        return new ServiceContext(axisService, serviceGroupContext);
    }

    public static String[] parseRequestURLForServiceAndOperation(String path) {
        String[] values = new String[2];
        int index = path.lastIndexOf("/services");
        if (-1 != index) {
            int operationIndex;
            int serviceStart = index + "/services".length();
            String service = path.substring(serviceStart + 1);
            int queryIndex = service.indexOf(63);
            if (queryIndex > 0) {
                service = service.substring(0, queryIndex);
            }
            if ((operationIndex = service.indexOf(47)) > 0) {
                values[0] = service.substring(0, operationIndex);
                values[1] = service.substring(operationIndex + 1);
            } else {
                values[0] = service;
            }
        }
        return values;
    }

    public static ConfigurationContext getNewConfigurationContext(String repositry) throws Exception {
        ConfigurationContextFactory erfac = new ConfigurationContextFactory();
        File file = new File(repositry);
        if (!file.exists()) {
            throw new Exception("repository directory " + file.getAbsolutePath() + " does not exists");
        }
        return erfac.createConfigurationContextFromFileSystem(file.getAbsolutePath());
    }

    public static String getParameterValue(Parameter param) {
        if (param == null) {
            return null;
        }
        return (String)param.getValue();
    }

    private static String getModuleName(String moduleName) {
        int version_seperator = 45;
        int version_index = moduleName.indexOf(version_seperator);
        if (version_index > 0) {
            return moduleName.substring(0, version_index);
        }
        return moduleName;
    }

    private static String getModuleVersion(String moduleName) {
        int version_seperator = 45;
        int version_index = moduleName.indexOf(version_seperator);
        if (version_index > 0) {
            return moduleName.substring(version_index + 1, moduleName.length());
        }
        return null;
    }

    public static QName getModuleName(String name, String versionID) {
        return new QName(name + "-" + versionID);
    }

    public static void calculateDefaultModuleVersion(HashMap modules, AxisConfiguration axisConfig) {
        Object moduleName;
        Iterator allModules = modules.values().iterator();
        HashMap<String, String> defaultModules = new HashMap<String, String>();
        while (allModules.hasNext()) {
            ModuleDescription moduleDescription = (ModuleDescription)allModules.next();
            moduleName = moduleDescription.getName();
            String moduleNameString = Utils.getModuleName(((QName)moduleName).getLocalPart());
            String moduleVersionString = Utils.getModuleVersion(((QName)moduleName).getLocalPart());
            String currentDefaultVerison = (String)defaultModules.get(moduleNameString);
            if (currentDefaultVerison != null) {
                if (!Utils.isLatest(moduleVersionString, currentDefaultVerison)) continue;
                defaultModules.put(moduleNameString, moduleVersionString);
                continue;
            }
            defaultModules.put(moduleNameString, moduleVersionString);
        }
        Iterator def_mod_itr = defaultModules.keySet().iterator();
        while (def_mod_itr.hasNext()) {
            moduleName = (String)def_mod_itr.next();
            axisConfig.addDefaultModuleVersion((String)moduleName, (String)defaultModules.get(moduleName));
        }
    }

    public static boolean isLatest(String moduleVersion, String currentDefaultVersion) {
        float m_c_vresion;
        float m_version = Float.parseFloat(moduleVersion);
        return m_version > (m_c_vresion = Float.parseFloat(currentDefaultVersion));
    }
}

