/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.builder;

import java.io.IOException;
import java.io.InputStream;
import javax.wsdl.WSDLException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.wsdl.builder.WOMBuilder;
import org.apache.axis2.wsdl.builder.WSDL2ToWOMBuilder;
import org.apache.axis2.wsdl.builder.wsdl4j.WSDL1ToWOMBuilder;
import org.apache.wsdl.util.Utils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WOMBuilderFactory {
    public static WOMBuilder getBuilder(int wsdlDocumentType) throws WSDLException {
        if (wsdlDocumentType == 1) {
            return new WSDL1ToWOMBuilder();
        }
        if (wsdlDocumentType == 2) {
            return new WSDL2ToWOMBuilder();
        }
        throw new WSDLException("INVALID_WSDL", "The document type specified is not valid");
    }

    public static WOMBuilder getBuilder(InputStream in) throws WSDLException {
        Document doc;
        try {
            doc = Utils.newDocument(in);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Exception", (Throwable)e);
        }
        catch (IOException e1) {
            throw new WSDLException("PARSER_ERROR", "WSDL Document read error", (Throwable)e1);
        }
        catch (SAXException e2) {
            throw new WSDLException("PARSER_ERROR", "Parser Exception", (Throwable)e2);
        }
        int version = WOMBuilderFactory.getWSDLVersion(doc);
        if (version == 1) {
            return new WSDL1ToWOMBuilder();
        }
        if (version == 2) {
            return new WSDL2ToWOMBuilder();
        }
        throw new WSDLException("OTHER_ERROR", "Unable to Figure out the WSDL vesion of the Document");
    }

    private static int getWSDLVersion(Document doc) throws WSDLException {
        if ("http://www.w3.org/2004/03/wsdl".equals(doc.getDocumentElement().getNamespaceURI())) {
            return 2;
        }
        if ("http://schemas.xmlsoap.org/wsdl/".equals(doc.getDocumentElement().getNamespaceURI())) {
            return 1;
        }
        throw new WSDLException("OTHER_ERROR", "Unable to Figure out the WSDL vesion of the Document");
    }
}

