/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.builder.wsdl4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.WSDLVersionWrapper;
import org.apache.axis2.wsdl.builder.WOMBuilder;
import org.apache.axis2.wsdl.builder.WSDLComponentFactory;
import org.apache.axis2.wsdl.builder.wsdl4j.WSDLPump;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.impl.WSDLDescriptionImpl;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WSDL1ToWOMBuilder
implements WOMBuilder {
    public WSDLVersionWrapper build(InputStream in) throws WSDLException {
        return this.build(in, null);
    }

    public WSDLVersionWrapper build(InputStream in, WSDLComponentFactory wsdlComponentFactory) throws WSDLException {
        if (null == wsdlComponentFactory) {
            wsdlComponentFactory = new WSDLDescriptionImpl();
        }
        WSDLDescription wsdlDescription = wsdlComponentFactory.createDescription();
        Definition wsdl1Definition = this.readInTheWSDLFile(in);
        WSDLPump pump = new WSDLPump(wsdlDescription, wsdl1Definition);
        pump.pump();
        return new WSDLVersionWrapper(wsdlDescription, wsdl1Definition);
    }

    public WSDLVersionWrapper build(String uri) throws WSDLException {
        return this.build(uri, null);
    }

    public WSDLVersionWrapper build(String uri, WSDLComponentFactory wsdlComponentFactory) throws WSDLException {
        if (null == wsdlComponentFactory) {
            wsdlComponentFactory = new WSDLDescriptionImpl();
        }
        WSDLDescription wsdlDescription = wsdlComponentFactory.createDescription();
        Definition wsdl1Definition = this.readInTheWSDLFile(uri);
        WSDLPump pump = new WSDLPump(wsdlDescription, wsdl1Definition, wsdlComponentFactory);
        pump.pump();
        return new WSDLVersionWrapper(wsdlDescription, wsdl1Definition);
    }

    private Definition readInTheWSDLFile(String uri) throws WSDLException {
        Document doc;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", true);
        File file = new File(uri);
        String baseURI = file.getParentFile() != null ? file.getParentFile().toURI().toString() : null;
        try {
            doc = XMLUtils.newDocument(uri);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", (Throwable)e);
        }
        return reader.readWSDL(baseURI, doc);
    }

    private Definition readInTheWSDLFile(InputStream in) throws WSDLException {
        Document doc;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", true);
        try {
            doc = XMLUtils.newDocument(in);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", (Throwable)e);
        }
        return reader.readWSDL(null, doc);
    }
}

