/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.java2wsdl;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.wsdl.builder.WSDLComponentFactory;
import org.apache.axis2.wsdl.java2wsdl.SchemaGenerator;
import org.apache.axis2.wsdl.java2wsdl.TypeTable;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.wsdl.MessageReference;
import org.apache.wsdl.WSDLBinding;
import org.apache.wsdl.WSDLBindingMessageReference;
import org.apache.wsdl.WSDLBindingOperation;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.WSDLEndpoint;
import org.apache.wsdl.WSDLInterface;
import org.apache.wsdl.WSDLOperation;
import org.apache.wsdl.WSDLService;
import org.apache.wsdl.WSDLTypes;
import org.apache.wsdl.extensions.ExtensionConstants;
import org.apache.wsdl.extensions.ExtensionFactory;
import org.apache.wsdl.extensions.Schema;
import org.apache.wsdl.extensions.impl.SOAPAddressImpl;
import org.apache.wsdl.extensions.impl.SOAPBindingImpl;
import org.apache.wsdl.extensions.impl.SOAPBodyImpl;
import org.apache.wsdl.extensions.impl.SOAPOperationImpl;
import org.apache.wsdl.impl.WSDLDescriptionImpl;
import org.codehaus.jam.JMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Java2WOM {
    private TypeTable table;
    private JMethod[] method;
    private XmlSchema schema;
    private String serviceName;
    private String targentNamespece;
    private String targetNamespecheprefix;

    public Java2WOM(TypeTable table, JMethod[] method, XmlSchema schema, String serviceName, String targentNamespece, String targetNamespecheprefix) {
        this.table = table;
        this.method = method;
        this.schema = schema;
        this.serviceName = serviceName;
        if (targentNamespece != null && !targentNamespece.trim().equals("")) {
            this.targentNamespece = targentNamespece;
        }
        if (targetNamespecheprefix != null && !targetNamespecheprefix.trim().equals("")) {
            this.targetNamespecheprefix = targetNamespecheprefix;
        }
    }

    public WSDLDescription generateWOM() throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        StringWriter writer = new StringWriter();
        this.schema.write((Writer)writer);
        writer.flush();
        Document doc = domBuilder.parse(new ByteArrayInputStream(writer.toString().getBytes()));
        Element documentElement = doc.getDocumentElement();
        WSDLDescriptionImpl wsdlComponentFactory = new WSDLDescriptionImpl();
        WSDLDescription womDescription = wsdlComponentFactory.createDescription();
        HashMap<String, String> namspaceMap = new HashMap<String, String>();
        namspaceMap.put("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        namspaceMap.put(this.targetNamespecheprefix, this.targentNamespece);
        namspaceMap.put("ns1", "http://org.apache.axis2/xsd");
        namspaceMap.put("xs", "http://www.w3.org/2001/XMLSchema");
        womDescription.setNamespaces(namspaceMap);
        womDescription.setTargetNameSpace(this.targentNamespece);
        WSDLInterface portType = this.generatePortType(womDescription, wsdlComponentFactory, documentElement);
        womDescription.addInterface(portType);
        QName bindingName = new QName(this.targentNamespece, this.serviceName + "Binding", this.targetNamespecheprefix);
        WSDLBinding binding = this.generateBinding(wsdlComponentFactory, portType, bindingName, "document", "literal", "http://schemas.xmlsoap.org/soap/http", "http://www.org.apache.axis2");
        womDescription.addBinding(binding);
        WSDLService service = this.generateService(wsdlComponentFactory, womDescription, binding, this.serviceName);
        womDescription.addService(service);
        return womDescription;
    }

    public WSDLInterface generatePortType(WSDLDescription womDescription, WSDLComponentFactory wsdlComponentFactory, Element documentElement) {
        WSDLTypes wsdlTypes = wsdlComponentFactory.createTypes();
        ExtensionFactory extensionFactory = wsdlComponentFactory.createExtensionFactory();
        Schema schemaExtensibilityElement = (Schema)extensionFactory.getExtensionElement(ExtensionConstants.SCHEMA);
        wsdlTypes.addExtensibilityElement(schemaExtensibilityElement);
        schemaExtensibilityElement.setElement(documentElement);
        womDescription.setTypes(wsdlTypes);
        WSDLInterface portType = womDescription.createInterface();
        portType.setName(new QName(this.serviceName + "Port"));
        for (int i = 0; i < this.method.length; ++i) {
            JMethod jmethod = this.method[i];
            WSDLOperation operation = womDescription.createOperation();
            operation.setName(new QName(jmethod.getSimpleName()));
            MessageReference messageRefinput = wsdlComponentFactory.createMessageReference();
            QName typeName = this.table.getComplexScheamType(jmethod.getSimpleName() + SchemaGenerator.METHOD_REQUEST_WRAPPER);
            messageRefinput.setElementQName(typeName);
            messageRefinput.setDirection("in");
            operation.setInputMessage(messageRefinput);
            portType.setOperation(operation);
            if (jmethod.getReturnType().isVoidType()) continue;
            MessageReference messageRefiout = wsdlComponentFactory.createMessageReference();
            messageRefiout.setElementQName(this.table.getQNamefortheType(jmethod.getSimpleName() + SchemaGenerator.METHOD_RESPONSE_WRAPPER));
            messageRefiout.setDirection("out");
            operation.setOutputMessage(messageRefiout);
        }
        return portType;
    }

    public WSDLService generateService(WSDLComponentFactory wsdlComponentFactory, WSDLDescription womDescription, WSDLBinding binding, String ServiceName2) {
        WSDLService service = wsdlComponentFactory.createService();
        service.setName(new QName(ServiceName2));
        WSDLEndpoint endpoints = wsdlComponentFactory.createEndpoint();
        endpoints.setBinding(binding);
        endpoints.setName(new QName(ServiceName2 + "PortType"));
        SOAPAddressImpl address = new SOAPAddressImpl();
        address.setLocationURI("http://127.0.0.1:8080:/axis2/services/" + ServiceName2);
        endpoints.addExtensibilityElement(address);
        service.setEndpoint(endpoints);
        return service;
    }

    private WSDLBinding generateBinding(WSDLComponentFactory wsdlComponentFactory, WSDLInterface portType, QName bindingName, String style, String use, String trsportURI, String namespeceURI) {
        WSDLBinding binding = wsdlComponentFactory.createBinding();
        binding.setBoundInterface(portType);
        binding.setName(bindingName);
        SOAPBindingImpl soapbindingImpl = new SOAPBindingImpl();
        soapbindingImpl.setStyle(style);
        soapbindingImpl.setTransportURI(trsportURI);
        binding.addExtensibilityElement(soapbindingImpl);
        Iterator op_itr = portType.getOperations().keySet().iterator();
        while (op_itr.hasNext()) {
            MessageReference outMessage;
            String opName = (String)op_itr.next();
            WSDLOperation wsdlOperation = portType.getOperation(opName);
            MessageReference inMessage = wsdlOperation.getInputMessage();
            WSDLBindingOperation bindingoperation = wsdlComponentFactory.createWSDLBindingOperation();
            bindingoperation.setName(new QName(opName));
            bindingoperation.setOperation(wsdlOperation);
            binding.addBindingOperation(bindingoperation);
            SOAPOperationImpl soapOpimpl = new SOAPOperationImpl();
            soapOpimpl.setStyle(style);
            soapOpimpl.setSoapAction(opName);
            bindingoperation.addExtensibilityElement(soapOpimpl);
            if (inMessage != null) {
                WSDLBindingMessageReference bindingInMessage = wsdlComponentFactory.createWSDLBindingMessageReference();
                bindingInMessage.setDirection("in");
                bindingoperation.setInput(bindingInMessage);
                SOAPBodyImpl requestSoapbody = new SOAPBodyImpl();
                requestSoapbody.setUse(use);
                requestSoapbody.setNamespaceURI(namespeceURI);
                bindingInMessage.addExtensibilityElement(requestSoapbody);
            }
            if ((outMessage = wsdlOperation.getOutputMessage()) == null) continue;
            WSDLBindingMessageReference bindingOutMessage = wsdlComponentFactory.createWSDLBindingMessageReference();
            bindingOutMessage.setDirection("out");
            bindingoperation.setOutput(bindingOutMessage);
            SOAPBodyImpl resSoapbody = new SOAPBodyImpl();
            resSoapbody.setUse(use);
            resSoapbody.setNamespaceURI(namespeceURI);
            bindingOutMessage.addExtensibilityElement(resSoapbody);
        }
        return binding;
    }
}

