/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.java2wsdl;

import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis2.wsdl.java2wsdl.TypeTable;
import org.apache.axis2.wsdl.java2wsdl.bytecode.MethodTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JMethod;
import org.codehaus.jam.JParameter;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class SchemaGenerator {
    protected Log log = LogFactory.getLog(this.getClass());
    private ClassLoader classLoader;
    private String className;
    private XmlSchema schema;
    private TypeTable typeTable;
    private JMethod[] methods;
    private MethodTable methodTable;
    public static String METHOD_REQUEST_WRAPPER = "Request";
    public static String METHOD_RESPONSE_WRAPPER = "Response";
    public static String TARGET_NAMESPACE = "http://org.apache.axis2/";
    public static String SCHEMA_TARGET_NAMESPACE = "http://org.apache.axis2/xsd";
    public static String SCHEMA_NAMESPACE_PRFIX = "ns1";
    public static String TARGET_NAMESPACE_PREFIX = "tns";
    private String schemaTargetNameSpace;
    private String schema_namespace_prefix;

    public SchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix) {
        this.classLoader = loader;
        this.className = className;
        this.schemaTargetNameSpace = schematargetNamespace != null && !schematargetNamespace.trim().equals("") ? schematargetNamespace : SCHEMA_TARGET_NAMESPACE;
        this.schema_namespace_prefix = schematargetNamespacePrefix != null && !schematargetNamespacePrefix.trim().equals("") ? schematargetNamespacePrefix : SCHEMA_NAMESPACE_PRFIX;
        Hashtable<String, String> prefixmap = new Hashtable<String, String>();
        prefixmap.put(this.schema_namespace_prefix, this.schemaTargetNameSpace);
        XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
        this.schema = new XmlSchema(this.schemaTargetNameSpace, schemaCollection);
        this.schema.setElementFormDefault(new XmlSchemaForm("qualified"));
        this.schema.setPrefixToNamespaceMap(prefixmap);
        this.typeTable = new TypeTable();
        try {
            Class<?> clazz = Class.forName(className, true, loader);
            this.methodTable = new MethodTable(clazz);
        }
        catch (Exception e) {
            this.log.info((Object)("Error in loading service impl class for byte code reading : " + e.getMessage()));
        }
    }

    public XmlSchema generateSchema() throws Exception {
        JamServiceFactory factory = JamServiceFactory.getInstance();
        JamServiceParams jam_service_parms = factory.createServiceParams();
        jam_service_parms.addClassLoader(this.classLoader);
        jam_service_parms.includeClass(this.className);
        JamService service = factory.createService(jam_service_parms);
        JamClassIterator jClassIter = service.getClasses();
        while (jClassIter.hasNext()) {
            JClass jclass = (JClass)jClassIter.next();
            this.methods = jclass.getDeclaredMethods();
            HashMap<String, JMethod> uniqueMethods = new HashMap<String, JMethod>();
            for (int i = 0; i < this.methods.length; ++i) {
                JMethod jMethod = this.methods[i];
                if (jMethod.getSimpleName().equals("init")) continue;
                if (uniqueMethods.get(jMethod.getSimpleName()) != null) {
                    throw new Exception(" Sorry we don't support methods overloading !!!! ");
                }
                if (!jMethod.isPublic()) continue;
                uniqueMethods.put(jMethod.getSimpleName(), jMethod);
                JParameter[] paras = jMethod.getParameters();
                for (int j = 0; j < paras.length; ++j) {
                    JParameter methodParameter = paras[j];
                    JClass paraType = methodParameter.getType();
                    String classTypeName = paraType.getQualifiedName();
                    if (paraType.isArrayType()) {
                        classTypeName = paraType.getArrayComponentType().getQualifiedName();
                        if (this.typeTable.isSimpleType(classTypeName)) continue;
                        this.generateSchema(paraType.getArrayComponentType());
                        continue;
                    }
                    if (this.typeTable.isSimpleType(classTypeName)) continue;
                    this.generateSchema(methodParameter.getType());
                }
                JClass retuenType = jMethod.getReturnType();
                if (retuenType.isVoidType()) continue;
                if (retuenType.isArrayType()) {
                    String returnTypeName = retuenType.getArrayComponentType().getQualifiedName();
                    if (this.typeTable.isSimpleType(returnTypeName)) continue;
                    this.generateSchema(retuenType.getArrayComponentType());
                    continue;
                }
                if (this.typeTable.isSimpleType(retuenType.getQualifiedName())) continue;
                this.generateSchema(retuenType);
            }
            this.generateWrapperElements(this.methods);
        }
        return this.schema;
    }

    private void generateWrapperElements(JMethod[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            JMethod method = methods[i];
            if (method.getSimpleName().equals("init") || !method.isPublic()) continue;
            this.genereteWrapperElementforMethod(method);
        }
    }

    private void genereteWrapperElementforMethod(JMethod method) {
        String methodName = method.getSimpleName();
        XmlSchemaComplexType complexType = new XmlSchemaComplexType(this.schema);
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        XmlSchemaElement eltOuter = new XmlSchemaElement();
        eltOuter.setName(methodName + METHOD_REQUEST_WRAPPER);
        this.schema.getItems().add((XmlSchemaObject)eltOuter);
        eltOuter.setSchemaType((XmlSchemaType)complexType);
        QName elementName = new QName(this.schemaTargetNameSpace, eltOuter.getName(), this.schema_namespace_prefix);
        this.typeTable.addComplexScheam(methodName + METHOD_REQUEST_WRAPPER, elementName);
        JParameter[] paras = method.getParameters();
        if (paras.length > 0) {
            complexType.setParticle((XmlSchemaParticle)sequence);
        }
        String[] parameterNames = null;
        if (paras.length > 0) {
            parameterNames = this.methodTable.getParameterNames(methodName);
        }
        for (int j = 0; j < paras.length; ++j) {
            XmlSchemaElement elt1;
            JParameter methodParameter = paras[j];
            String paraName = methodParameter.getSimpleName();
            String classTypeName = methodParameter.getType().getQualifiedName();
            boolean isArryType = methodParameter.getType().isArrayType();
            if (isArryType) {
                classTypeName = methodParameter.getType().getArrayComponentType().getQualifiedName();
            }
            if (parameterNames != null) {
                paraName = parameterNames[j];
            }
            if (this.typeTable.isSimpleType(classTypeName)) {
                elt1 = new XmlSchemaElement();
                elt1.setName(paraName);
                elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(classTypeName));
                sequence.getItems().add((XmlSchemaObject)elt1);
                if (!isArryType) continue;
                elt1.setMaxOccurs(Long.MAX_VALUE);
                continue;
            }
            elt1 = new XmlSchemaElement();
            elt1.setName(paraName);
            elt1.setSchemaTypeName(this.typeTable.getComplexScheamType(classTypeName));
            sequence.getItems().add((XmlSchemaObject)elt1);
            if (!isArryType) continue;
            elt1.setMaxOccurs(Long.MAX_VALUE);
        }
        JClass methodReturnType = method.getReturnType();
        this.generateWrapperforReturnType(methodReturnType, methodName);
    }

    private void generateWrapperforReturnType(JClass retuenType, String methodName) {
        if (!retuenType.isVoidType()) {
            XmlSchemaComplexType retuen_com_type = new XmlSchemaComplexType(this.schema);
            XmlSchemaElement ret_eltOuter = new XmlSchemaElement();
            ret_eltOuter.setName(methodName + METHOD_RESPONSE_WRAPPER);
            this.schema.getItems().add((XmlSchemaObject)ret_eltOuter);
            ret_eltOuter.setSchemaType((XmlSchemaType)retuen_com_type);
            QName ret_comTypeName = new QName(this.schemaTargetNameSpace, ret_eltOuter.getName(), this.schema_namespace_prefix);
            this.typeTable.addComplexScheam(methodName + METHOD_RESPONSE_WRAPPER, ret_comTypeName);
            String classTypeName = retuenType.getQualifiedName();
            boolean isArryType = retuenType.isArrayType();
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            retuen_com_type.setParticle((XmlSchemaParticle)sequence);
            if (isArryType) {
                classTypeName = retuenType.getArrayComponentType().getQualifiedName();
            }
            if (this.typeTable.isSimpleType(classTypeName)) {
                XmlSchemaElement elt1 = new XmlSchemaElement();
                elt1.setName("return");
                elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(classTypeName));
                sequence.getItems().add((XmlSchemaObject)elt1);
                if (isArryType) {
                    elt1.setMaxOccurs(Long.MAX_VALUE);
                }
            } else {
                XmlSchemaElement elt1 = new XmlSchemaElement();
                elt1.setName("return");
                elt1.setSchemaTypeName(this.typeTable.getComplexScheamType(classTypeName));
                sequence.getItems().add((XmlSchemaObject)elt1);
                if (isArryType) {
                    elt1.setMaxOccurs(Long.MAX_VALUE);
                }
            }
        }
    }

    private void generateSchema(JClass javaType) {
        String name = javaType.getQualifiedName();
        if (this.typeTable.getComplexScheamType(name) == null) {
            String simpleName = javaType.getSimpleName();
            XmlSchemaComplexType complexType = new XmlSchemaComplexType(this.schema);
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            XmlSchemaElement eltOuter = new XmlSchemaElement();
            QName elemntName = new QName(this.schemaTargetNameSpace, simpleName, this.schema_namespace_prefix);
            eltOuter.setName(simpleName);
            eltOuter.setQName(elemntName);
            complexType.setParticle((XmlSchemaParticle)sequence);
            complexType.setName(simpleName);
            this.schema.getItems().add((XmlSchemaObject)eltOuter);
            this.schema.getItems().add((XmlSchemaObject)complexType);
            eltOuter.setSchemaTypeName(complexType.getQName());
            this.typeTable.addComplexScheam(name, eltOuter.getQName());
            JProperty[] properties = javaType.getDeclaredProperties();
            for (int i = 0; i < properties.length; ++i) {
                XmlSchemaElement elt1;
                JProperty property = properties[i];
                String propertyName = property.getType().getQualifiedName();
                boolean isArryType = property.getType().isArrayType();
                if (isArryType) {
                    propertyName = property.getType().getArrayComponentType().getQualifiedName();
                }
                if (this.typeTable.isSimpleType(propertyName)) {
                    elt1 = new XmlSchemaElement();
                    elt1.setName(property.getSimpleName());
                    elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(propertyName));
                    sequence.getItems().add((XmlSchemaObject)elt1);
                    if (!isArryType) continue;
                    elt1.setMaxOccurs(Long.MAX_VALUE);
                    continue;
                }
                if (isArryType) {
                    this.generateSchema(property.getType().getArrayComponentType());
                } else {
                    this.generateSchema(property.getType());
                }
                elt1 = new XmlSchemaElement();
                elt1.setName(property.getSimpleName());
                elt1.setSchemaTypeName(this.typeTable.getComplexScheamType(propertyName));
                sequence.getItems().add((XmlSchemaObject)elt1);
                if (!isArryType) continue;
                elt1.setMaxOccurs(Long.MAX_VALUE);
            }
        }
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public JMethod[] getMethods() {
        return this.methods;
    }
}

