/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.writer;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.om.OMAbstractFactory;
import org.apache.axis2.om.OMElement;
import org.apache.axis2.om.OMFactory;
import org.apache.axis2.om.impl.llom.builder.StAXOMBuilder;
import org.apache.axis2.wsdl.WSDLVersionWrapper;
import org.apache.axis2.wsdl.writer.WOMWriter;
import org.apache.axis2.wsdl.writer.WriterException;
import org.apache.axis2.wsdl.writer.WriterUtil;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.StAXPolicyWriter;
import org.apache.wsdl.MessageReference;
import org.apache.wsdl.WSDLBinding;
import org.apache.wsdl.WSDLBindingMessageReference;
import org.apache.wsdl.WSDLBindingOperation;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.WSDLEndpoint;
import org.apache.wsdl.WSDLExtensibilityAttribute;
import org.apache.wsdl.WSDLExtensibilityElement;
import org.apache.wsdl.WSDLImport;
import org.apache.wsdl.WSDLInterface;
import org.apache.wsdl.WSDLOperation;
import org.apache.wsdl.WSDLService;
import org.apache.wsdl.WSDLTypes;
import org.apache.wsdl.extensions.PolicyExtensibilityElement;
import org.apache.wsdl.extensions.SOAPAddress;
import org.apache.wsdl.extensions.SOAPBinding;
import org.apache.wsdl.extensions.SOAPBody;
import org.apache.wsdl.extensions.SOAPHeader;
import org.apache.wsdl.extensions.SOAPOperation;
import org.apache.wsdl.extensions.Schema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WOMtoWSDL11Writer
implements WOMWriter {
    private String encoding = "UTF-8";
    private String defaultWSDLPrefix = "wsdl11";
    private String targetNamespacePrefix = "tns";
    private static final String WSDL1_1_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/";
    private static final String WSDL1_1_SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String DEFINITION_NAME = "definitions";
    private static final String IMPORT_NAME = "import";
    private static final String TYPES_NAME = "types";
    private static final String PORTTYPE_NAME = "portType";
    private static final String MESSAGE_NAME_SUFFIX = "Message";
    private Map namespaceMap = new HashMap();
    private Map messageMap = new HashMap();
    private static final String BINDING_OPERATION = "operation";
    private static final String OPERATION_NAME = "operation";
    private static final String BINDING_INPUT = "input";
    private static final String INPUT_NAME = "input";
    private static final String BINDING_OUTPUT = "output";
    private static final String OUTPUT_NAME = "output";
    private static final String BINDING_NAME = "binding";
    private String soapNsPrefix = null;
    private XMLStreamWriter writer;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setdefaultWSDLPrefix(String defaultWSDLPrefix) {
        this.defaultWSDLPrefix = defaultWSDLPrefix;
    }

    public void writeWOM(WSDLVersionWrapper wsdlWrapper, OutputStream out) throws WriterException {
        if (wsdlWrapper == null) {
            throw new WriterException("wsdl Wrapper cannot be null");
        }
        if (wsdlWrapper.getDefinition() != null) {
            try {
                WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                writer.writeWSDL(wsdlWrapper.getDefinition(), out);
            }
            catch (WSDLException e) {
                throw new WriterException(e);
            }
        } else if (wsdlWrapper.getDescription() != null) {
            try {
                this.writeWOM(wsdlWrapper.getDescription(), out);
            }
            catch (XMLStreamException e) {
                throw new WriterException(e);
            }
        } else {
            throw new WriterException(" WSDL wrapper is empty!");
        }
    }

    public void writeWOM(WSDLDescription wsdlDescription, OutputStream out) throws WriterException, XMLStreamException {
        try {
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            this.writeStartDescripton(wsdlDescription, this.writer);
            this.findSOAPNsPrefix(wsdlDescription);
            this.writeImports(wsdlDescription);
            this.handleExtensibiltyElements(wsdlDescription.getExtensibilityElements());
            this.writeTypes(wsdlDescription);
            this.writeMessages(wsdlDescription);
            this.writePortTypes(wsdlDescription);
            this.writeBinding(wsdlDescription);
            this.writeService(wsdlDescription);
            this.writer.writeEndElement();
            this.writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new WriterException("wrong encoding!", e);
        }
        catch (IOException e) {
            throw new WriterException("Error writing to the stream!", e);
        }
    }

    private void writeService(WSDLDescription wsdlDescription) throws IOException, XMLStreamException {
        Map serviceMap = wsdlDescription.getServices();
        if (serviceMap != null && !serviceMap.isEmpty()) {
            Iterator serviceIterator = serviceMap.values().iterator();
            while (serviceIterator.hasNext()) {
                WSDLService service = (WSDLService)serviceIterator.next();
                this.writer.writeStartElement(this.defaultWSDLPrefix, "service", WSDL1_1_NAMESPACE_URI);
                this.writer.writeAttribute("name", service.getName().getLocalPart());
                this.handleExtensibiltyElements(service.getExtensibilityElements());
                HashMap endPointMap = service.getEndpoints();
                if (endPointMap != null && !endPointMap.isEmpty()) {
                    Iterator it = endPointMap.values().iterator();
                    while (it.hasNext()) {
                        this.writePort((WSDLEndpoint)it.next());
                    }
                }
                this.writer.writeEndElement();
            }
        }
    }

    private void writePort(WSDLEndpoint endpoint) throws IOException, XMLStreamException {
        this.writer.writeStartElement(this.defaultWSDLPrefix, "port", WSDL1_1_NAMESPACE_URI);
        this.writer.writeAttribute("name", endpoint.getName().getLocalPart());
        QName name = endpoint.getBinding().getName();
        this.writer.writeAttribute(BINDING_NAME, name.getPrefix() + ":" + name.getLocalPart());
        this.handleExtensibiltyElements(endpoint.getExtensibilityElements());
        this.writer.writeEndElement();
    }

    private void findSOAPNsPrefix(WSDLDescription wsdlDescription) {
        Map map = wsdlDescription.getNamespaces();
        Iterator nsIterator = map.values().iterator();
        Iterator keyIterator = map.keySet().iterator();
        while (nsIterator.hasNext()) {
            String key = keyIterator.next().toString();
            if (!WSDL1_1_SOAP_NAMESPACE_URI.equals(nsIterator.next())) continue;
            this.soapNsPrefix = key;
            break;
        }
    }

    protected void writeStartDescripton(WSDLDescription desc, XMLStreamWriter writer) throws IOException, XMLStreamException {
        writer.writeStartElement(this.defaultWSDLPrefix, DEFINITION_NAME, WSDL1_1_NAMESPACE_URI);
        QName wsdl1DefinitionName = desc.getWSDL1DefinitionName();
        if (wsdl1DefinitionName != null) {
            writer.writeAttribute("name", wsdl1DefinitionName.getLocalPart());
        }
        String targetNameSpace = desc.getTargetNameSpace();
        this.namespaceMap = desc.getNamespaces();
        if (this.namespaceMap != null && !this.namespaceMap.isEmpty()) {
            Iterator nameSpaces = this.namespaceMap.keySet().iterator();
            while (nameSpaces.hasNext()) {
                String nsPrefix = (String)nameSpaces.next();
                String nsURI = this.namespaceMap.get(nsPrefix).toString();
                if (WSDL1_1_NAMESPACE_URI.equals(nsURI) || targetNameSpace.equals(nsURI)) continue;
                this.writeNamespace(nsPrefix, nsURI);
            }
        }
        this.writeNamespace(this.defaultWSDLPrefix, WSDL1_1_NAMESPACE_URI);
        this.writeNamespace(this.targetNamespacePrefix, targetNameSpace);
        writer.writeAttribute("targetNamespace", desc.getTargetNameSpace());
    }

    private void writeNamespace(String namespacePrefix, String namespaceURI) throws XMLStreamException {
        this.namespaceMap.put(namespacePrefix, namespaceURI);
        this.writer.writeNamespace(namespacePrefix, namespaceURI);
    }

    protected void writeMessages(WSDLDescription desc) throws XMLStreamException {
        Map interfaceMap;
        Map mBag = desc.getMetadataBag();
        if ((mBag == null || mBag.isEmpty()) && !(interfaceMap = desc.getWsdlInterfaces()).isEmpty()) {
            Iterator interfaceIterator = interfaceMap.values().iterator();
            while (interfaceIterator.hasNext()) {
                WSDLInterface wsdlInterface = (WSDLInterface)interfaceIterator.next();
                HashMap opMap = wsdlInterface.getOperations();
                if (opMap.isEmpty()) continue;
                Iterator opIterator = opMap.values().iterator();
                while (opIterator.hasNext()) {
                    QName outputReference;
                    QName inputReference;
                    WSDLOperation operation = (WSDLOperation)opIterator.next();
                    QName qName = inputReference = operation.getInputMessage() == null ? null : operation.getInputMessage().getElementQName();
                    if (inputReference != null) {
                        this.populateMessageSymbol(inputReference);
                    }
                    if ((outputReference = operation.getOutputMessage() == null ? null : operation.getOutputMessage().getElementQName()) == null) continue;
                    this.populateMessageSymbol(outputReference);
                }
            }
            Iterator messages = this.messageMap.values().iterator();
            while (messages.hasNext()) {
                WSDL11Message msg = (WSDL11Message)messages.next();
                this.writer.writeStartElement(this.defaultWSDLPrefix, "message", WSDL1_1_NAMESPACE_URI);
                this.writer.writeAttribute("name", msg.getMessageName());
                WSDL11MessagePart[] parts = msg.getParts();
                for (int i = 0; i < parts.length; ++i) {
                    WSDL11MessagePart part = parts[i];
                    this.writer.writeStartElement(this.defaultWSDLPrefix, "part", WSDL1_1_NAMESPACE_URI);
                    this.writer.writeAttribute("name", part.getName());
                    String elementName = part.getElementName();
                    if (elementName != null) {
                        if (part.getPrefix() != null && !part.getPrefix().trim().equals("")) {
                            elementName = part.getPrefix() + ":" + elementName;
                        }
                        this.writer.writeAttribute("element", elementName);
                    }
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            }
        }
    }

    private void populateMessageSymbol(QName reference) {
        if (!this.messageMap.containsKey(reference)) {
            WSDL11MessagePart part = new WSDL11MessagePart();
            part.setName("part1");
            part.setElementName(reference.getLocalPart());
            part.setPrefix(reference.getPrefix());
            WSDL11Message message = new WSDL11Message();
            message.setMessageName(reference.getLocalPart() + MESSAGE_NAME_SUFFIX);
            message.setParts(new WSDL11MessagePart[]{part});
            this.messageMap.put(reference, message);
        }
    }

    protected void writeEndDescripton(Writer outWriter) throws IOException {
        WriterUtil.writeEndElement(DEFINITION_NAME, this.defaultWSDLPrefix, outWriter);
    }

    protected void writeImports(WSDLDescription desc) throws IOException, XMLStreamException {
        ArrayList imports = desc.getImports();
        int importCount = imports.size();
        for (int i = 0; i < importCount; ++i) {
            WSDLImport singleImport = (WSDLImport)imports.get(i);
            this.writer.writeStartElement(this.defaultWSDLPrefix, IMPORT_NAME, WSDL1_1_NAMESPACE_URI);
            this.writer.writeAttribute("namespace", singleImport.getNamespace());
            this.writer.writeAttribute("location", singleImport.getLocation());
            this.writer.writeEndElement();
        }
    }

    protected void writeTypes(WSDLDescription desc) throws IOException, XMLStreamException {
        WSDLTypes types = desc.getTypes();
        if (types != null) {
            this.writer.writeStartElement(this.defaultWSDLPrefix, TYPES_NAME, WSDL1_1_NAMESPACE_URI);
            this.handleExtensibiltyElements(types.getExtensibilityElements());
            this.writer.writeEndElement();
        }
    }

    protected void writePortTypes(WSDLDescription desc) throws XMLStreamException, IOException {
        Map interfaceMap = desc.getWsdlInterfaces();
        if (!interfaceMap.isEmpty()) {
            Iterator interfaceIterator = interfaceMap.values().iterator();
            while (interfaceIterator.hasNext()) {
                WSDLInterface wsdlInterface = (WSDLInterface)interfaceIterator.next();
                this.writer.writeStartElement(this.defaultWSDLPrefix, PORTTYPE_NAME, WSDL1_1_NAMESPACE_URI);
                this.writer.writeAttribute("name", wsdlInterface.getName() == null ? "" : wsdlInterface.getName().getLocalPart());
                this.handleExtensibilityAttributes(wsdlInterface.getExtensibilityAttributes());
                this.writePorttypeOperations(wsdlInterface);
                this.writer.writeEndElement();
            }
        }
    }

    protected void writePorttypeOperations(WSDLInterface wsdlInterface) throws XMLStreamException, IOException {
        HashMap operationsMap = wsdlInterface.getOperations();
        if (!operationsMap.isEmpty()) {
            Iterator opIterator = operationsMap.values().iterator();
            while (opIterator.hasNext()) {
                MessageReference outputMessage;
                WSDL11Message message;
                WSDLOperation operation = (WSDLOperation)opIterator.next();
                this.writer.writeStartElement(this.defaultWSDLPrefix, "operation", WSDL1_1_NAMESPACE_URI);
                this.writer.writeAttribute("name", operation.getName() == null ? "" : operation.getName().getLocalPart());
                this.handleExtensibiltyElements(operation.getExtensibilityElements());
                MessageReference inputMessage = operation.getInputMessage();
                if (inputMessage != null) {
                    message = (WSDL11Message)this.messageMap.get(inputMessage.getElementQName());
                    this.writer.writeStartElement(this.defaultWSDLPrefix, "input", WSDL1_1_NAMESPACE_URI);
                    this.writer.writeAttribute("message", this.targetNamespacePrefix + ":" + message.getMessageName());
                    this.handleExtensibilityAttributes(inputMessage.getExtensibilityAttributes());
                    this.writer.writeEndElement();
                }
                if ((outputMessage = operation.getOutputMessage()) != null) {
                    message = (WSDL11Message)this.messageMap.get(outputMessage.getElementQName());
                    this.writer.writeStartElement(this.defaultWSDLPrefix, "output", WSDL1_1_NAMESPACE_URI);
                    this.writer.writeAttribute("message", this.targetNamespacePrefix + ":" + message.getMessageName());
                    this.handleExtensibilityAttributes(outputMessage.getExtensibilityAttributes());
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            }
        }
    }

    protected void writeBinding(WSDLDescription desc) throws XMLStreamException, IOException {
        Map bindingsMap = desc.getBindings();
        if (!bindingsMap.isEmpty()) {
            Iterator iterator = bindingsMap.values().iterator();
            while (iterator.hasNext()) {
                WSDLBinding binding = (WSDLBinding)iterator.next();
                this.writer.writeStartElement(this.defaultWSDLPrefix, BINDING_NAME, WSDL1_1_NAMESPACE_URI);
                this.writer.writeAttribute("name", binding.getName().getLocalPart());
                this.writer.writeAttribute("type", this.targetNamespacePrefix + ":" + binding.getBoundInterface().getName().getLocalPart());
                this.handleExtensibiltyElements(binding.getExtensibilityElements());
                HashMap bindingOps = binding.getBindingOperations();
                if (bindingOps != null && !bindingOps.isEmpty()) {
                    Iterator bindingOpsIterator = bindingOps.values().iterator();
                    while (bindingOpsIterator.hasNext()) {
                        this.writebindingOperation((WSDLBindingOperation)bindingOpsIterator.next());
                    }
                }
                this.writer.writeEndElement();
            }
        }
    }

    protected void writebindingOperation(WSDLBindingOperation bindingOp) throws XMLStreamException, IOException {
        WSDLBindingMessageReference output;
        this.writer.writeStartElement(this.defaultWSDLPrefix, "operation", WSDL1_1_NAMESPACE_URI);
        this.writer.writeAttribute("name", bindingOp.getName().getLocalPart());
        this.handleExtensibiltyElements(bindingOp.getExtensibilityElements());
        WSDLBindingMessageReference input = bindingOp.getInput();
        if (input != null) {
            this.writer.writeStartElement(this.defaultWSDLPrefix, "input", WSDL1_1_NAMESPACE_URI);
            this.handleExtensibiltyElements(input.getExtensibilityElements());
            this.writer.writeEndElement();
        }
        if ((output = bindingOp.getOutput()) != null) {
            this.writer.writeStartElement(this.defaultWSDLPrefix, "output", WSDL1_1_NAMESPACE_URI);
            this.handleExtensibiltyElements(output.getExtensibilityElements());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    protected void handleExtensibilityAttributes(List extAttributeList) throws XMLStreamException {
        int extAttributeCount = extAttributeList.size();
        for (int i = 0; i < extAttributeCount; ++i) {
            this.writeExtensibilityAttribute((WSDLExtensibilityAttribute)extAttributeList.get(i));
        }
    }

    protected void handleExtensibiltyElements(List extElementList) throws XMLStreamException, IOException {
        int extensibilityElementCount = extElementList.size();
        for (int i = 0; i < extensibilityElementCount; ++i) {
            this.writeExtensibilityElement((WSDLExtensibilityElement)extElementList.get(i));
        }
    }

    private void writeSchemas(Element element) throws XMLStreamException {
        this.writer.flush();
        String schemaTypes = DOM2Writer.nodeToString((Node)element);
        XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(schemaTypes.getBytes()));
        OMFactory fac = OMAbstractFactory.getOMFactory();
        StAXOMBuilder staxOMBuilder = new StAXOMBuilder(fac, xmlReader);
        OMElement schemaElement = staxOMBuilder.getDocumentElement();
        schemaElement.serialize(this.writer);
    }

    protected void writeExtensibilityAttribute(WSDLExtensibilityAttribute extAttribute) throws XMLStreamException {
        QName qname = extAttribute.getKey();
        QName value = extAttribute.getValue();
        this.writer.writeAttribute(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart(), value.getLocalPart());
    }

    protected void writeExtensibilityElement(WSDLExtensibilityElement extElement) throws IOException, XMLStreamException {
        if (extElement instanceof Schema) {
            Element element = ((Schema)extElement).getElement();
            this.writeSchemas(element);
        } else if (extElement instanceof SOAPAddress) {
            this.writeSOAPAddressExtensibilityElement((SOAPAddress)extElement);
        } else if (extElement instanceof SOAPBinding) {
            this.writeSOAPBindingExtensibilityElement((SOAPBinding)extElement);
        } else if (extElement instanceof SOAPHeader) {
            this.writeSOAPHeaderExtensibilityElement((SOAPHeader)extElement);
        } else if (extElement instanceof SOAPOperation) {
            this.writeSOAPOpextensibilityElement((SOAPOperation)extElement);
        } else if (extElement instanceof SOAPBody) {
            this.writeSOAPBodyExtensibilityElement((SOAPBody)extElement);
        } else if (extElement instanceof PolicyExtensibilityElement) {
            this.writePolicyExtensibilityElement((PolicyExtensibilityElement)extElement);
        } else {
            this.writer.writeComment(" Unknown extensibility element" + extElement.toString());
        }
    }

    private void writeSOAPAddressExtensibilityElement(SOAPAddress address) throws XMLStreamException {
        this.writer.writeStartElement(this.soapNsPrefix, "address", WSDL1_1_SOAP_NAMESPACE_URI);
        this.writer.writeAttribute("location", address.getLocationURI());
        this.writer.writeEndElement();
    }

    protected void writeSOAPBindingExtensibilityElement(SOAPBinding soapBinding) throws XMLStreamException {
        this.writer.writeStartElement(this.soapNsPrefix, BINDING_NAME, WSDL1_1_SOAP_NAMESPACE_URI);
        this.writer.writeAttribute("transport", soapBinding.getTransportURI());
        this.writer.writeAttribute("style", soapBinding.getStyle());
        this.writer.writeEndElement();
    }

    protected void writeSOAPBodyExtensibilityElement(SOAPBody soapBody) throws IOException, XMLStreamException {
        this.writer.writeStartElement(this.soapNsPrefix, "body", WSDL1_1_SOAP_NAMESPACE_URI);
        this.writer.writeAttribute("use", soapBody.getUse());
        if (soapBody.getNamespaceURI() != null) {
            this.writer.writeAttribute("namespace", soapBody.getNamespaceURI());
        }
        this.writer.writeEndElement();
    }

    protected void writeSOAPHeaderExtensibilityElement(SOAPHeader soapHeader) throws XMLStreamException {
        this.writer.writeStartElement(this.soapNsPrefix, "header", WSDL1_1_SOAP_NAMESPACE_URI);
        this.writer.writeAttribute("use", soapHeader.getUse());
        this.writer.writeEndElement();
    }

    protected void writeSOAPOpextensibilityElement(SOAPOperation soapop) throws IOException, XMLStreamException {
        this.writer.writeStartElement(this.soapNsPrefix, "operation", WSDL1_1_SOAP_NAMESPACE_URI);
        this.writer.writeAttribute("name", soapop.getType().getLocalPart());
        this.writer.writeAttribute("soapAction", soapop.getSoapAction());
        this.writer.writeAttribute("style", soapop.getStyle());
        this.writer.writeEndElement();
    }

    protected void writePolicyExtensibilityElement(PolicyExtensibilityElement policyExtensibilityElement) throws XMLStreamException {
        StAXPolicyWriter policyWriter = (StAXPolicyWriter)PolicyFactory.getPolicyWriter((int)2);
        Object policyElement = policyExtensibilityElement.getPolicyElement();
        if (policyElement instanceof Policy) {
            policyWriter.writePolicy((Policy)policyElement, this.writer);
        } else if (policyElement instanceof PolicyReference) {
            policyWriter.writePolicyReference((PolicyReference)policyElement, this.writer);
        }
    }

    private class WSDL11MessagePart {
        private String name;
        private String elementName;
        private String type;
        private String prefix;

        private WSDL11MessagePart() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    private class WSDL11Message {
        private String messageName;
        private WSDL11MessagePart[] parts;

        private WSDL11Message() {
        }

        public String getMessageName() {
            return this.messageName;
        }

        public void setMessageName(String messageName) {
            this.messageName = messageName;
        }

        public WSDL11MessagePart[] getParts() {
            return this.parts;
        }

        public void setParts(WSDL11MessagePart[] parts) {
            this.parts = parts;
        }
    }
}

