/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.writer;

import java.io.IOException;
import java.io.Writer;

class WriterUtil {
    WriterUtil() {
    }

    public static void writeStartElement(String elementName, Writer writer) throws IOException {
        writer.write("<" + elementName);
    }

    public static void writeStartElement(String elementName, String nsPrefix, Writer writer) throws IOException {
        if (nsPrefix == null) {
            WriterUtil.writeStartElement(elementName, writer);
        } else {
            writer.write("<" + nsPrefix + ":" + elementName);
        }
    }

    public static void writeCloseStartElement(Writer writer) throws IOException {
        writer.write(">\n");
    }

    public static void writeAttribute(String attName, String value, Writer writer) throws IOException {
        writer.write(" " + attName + "=\"" + value + "\"");
    }

    public static void writeEndElement(String eltName, Writer writer) throws IOException {
        writer.write("</" + eltName + ">\n");
    }

    public static void writeCompactEndElement(Writer writer) throws IOException {
        writer.write("/>\n");
    }

    public static void writeEndElement(String eltName, String nsPrefix, Writer writer) throws IOException {
        if (nsPrefix == null) {
            WriterUtil.writeEndElement(eltName, writer);
        } else {
            writer.write("</" + nsPrefix + ":" + eltName + ">\n");
        }
    }

    public static void writeNamespace(String prefix, String namespaceURI, Writer writer) throws IOException {
        if (prefix == null || prefix.trim().length() == 0) {
            WriterUtil.writeAttribute("xmlns", namespaceURI, writer);
        } else {
            WriterUtil.writeAttribute("xmlns:" + prefix, namespaceURI, writer);
        }
    }

    public static void writeComment(String comment, Writer writer) throws IOException {
        writer.write("<!--" + comment + "-->");
    }
}

