/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsdl.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.wsdl.WSDLInterface;
import org.apache.wsdl.WSDLOperation;
import org.apache.wsdl.impl.ExtensibleComponentImpl;
import org.apache.wsdl.impl.WSDLProcessingException;

public class WSDLInterfaceImpl
extends ExtensibleComponentImpl
implements WSDLInterface {
    private QName name;
    private HashMap superInterfaces = new HashMap();
    private List faults = new LinkedList();
    private HashMap operations = new HashMap();
    private String styleDefault;

    public HashMap getDefinedOperations() {
        return this.operations;
    }

    public HashMap getAllOperations() {
        HashMap all = this.operations;
        if (this.superInterfaces.size() == 0) {
            return all;
        }
        Iterator superIterator = this.superInterfaces.values().iterator();
        Iterator thisIterator = all.values().iterator();
        boolean tobeAdded = false;
        while (superIterator.hasNext()) {
            WSDLInterface superInterface = (WSDLInterface)superIterator.next();
            Iterator operationIterator = superInterface.getAllOperations().values().iterator();
            while (operationIterator.hasNext()) {
                WSDLOperation superInterfaceOperation = (WSDLOperation)operationIterator.next();
                tobeAdded = true;
                while (thisIterator.hasNext()) {
                    WSDLOperation thisOperation = (WSDLOperation)thisIterator.next();
                    if (thisOperation.getName() != superInterfaceOperation.getName() || tobeAdded) continue;
                    if (thisOperation.getTargetnamespace().equals(superInterfaceOperation.getTargetnamespace())) {
                        tobeAdded = false;
                        continue;
                    }
                    throw new WSDLProcessingException("The Interface " + this.getName() + " has more than one Operation that has the same name but not the same interface ");
                }
                if (!tobeAdded) continue;
                all.put(superInterfaceOperation.getName().getLocalPart(), superInterfaceOperation);
            }
        }
        return all;
    }

    public List getFaults() {
        return this.faults;
    }

    public QName getName() {
        return this.name;
    }

    public HashMap getOperations() {
        return this.operations;
    }

    public WSDLOperation getOperation(String nCName) {
        return (WSDLOperation)this.operations.get(nCName);
    }

    public HashMap getSuperInterfaces() {
        return this.superInterfaces;
    }

    public WSDLInterface getSuperInterface(QName qName) {
        return (WSDLInterface)this.superInterfaces.get(qName);
    }

    public String getTargetnamespace() {
        if (null == this.name) {
            return null;
        }
        return this.name.getNamespaceURI();
    }

    public void setFaults(List list) {
        this.faults = list;
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public void setOperations(HashMap list) {
        this.operations = list;
    }

    public void setOperation(WSDLOperation operation) {
        if (null == operation) {
            return;
        }
        if (null == operation.getName()) {
            throw new WSDLProcessingException("The Operation name cannot be null (required)");
        }
        this.operations.put(operation.getName().getLocalPart(), operation);
    }

    public void setSuperInterfaces(HashMap list) {
        this.superInterfaces = list;
    }

    public void addSuperInterface(WSDLInterface interfaceComponent) {
        this.superInterfaces.put(interfaceComponent.getName(), interfaceComponent);
    }

    public String getStyleDefault() {
        return this.styleDefault;
    }

    public void setStyleDefault(String styleDefault) {
        this.styleDefault = styleDefault;
    }
}

