/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.google.common.collect.Lists;
import com.lambdaworks.redis.GeoCoordinates;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandOutput;
import java.nio.ByteBuffer;
import java.util.List;

public class GeoCoordinatesListOutput<K, V>
extends CommandOutput<K, V, List<GeoCoordinates>> {
    private Double x;

    public GeoCoordinatesListOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        Double value = bytes == null ? 0.0 : Double.parseDouble(this.decodeAscii(bytes));
        if (this.x == null) {
            this.x = value;
            return;
        }
        ((List)this.output).add(new GeoCoordinates(this.x, value));
        this.x = null;
    }

    @Override
    public void multi(int count) {
        if (this.output == null) {
            this.output = Lists.newArrayListWithCapacity((int)count);
        } else if (count == -1) {
            ((List)this.output).add(null);
        }
    }
}

