/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.google.common.base.Supplier;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.protocol.ChannelLogDescriptor;
import com.lambdaworks.redis.protocol.CommandHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter
implements TimerTask {
    public static final long LOGGING_QUIET_TIME_MS = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    public static final int RETRY_TIMEOUT_MAX = 14;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ConnectionWatchdog.class);
    private final EventExecutorGroup reconnectWorkers;
    private final ClientOptions clientOptions;
    private final Bootstrap bootstrap;
    private boolean listenOnChannelInactive;
    private boolean reconnectSuspended;
    private Channel channel;
    private final Timer timer;
    private final Supplier<SocketAddress> socketAddressSupplier;
    private SocketAddress remoteAddress;
    private int attempts;
    private long lastReconnectionLogging = -1L;
    private String logPrefix;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private long timeout = 60L;
    private volatile ChannelFuture currentFuture;

    public ConnectionWatchdog(ClientOptions clientOptions, Bootstrap bootstrap, EventExecutorGroup reconnectWorkers, Timer timer) {
        this(clientOptions, bootstrap, timer, reconnectWorkers, null);
    }

    public ConnectionWatchdog(ClientOptions clientOptions, Bootstrap bootstrap, Timer timer, EventExecutorGroup reconnectWorkers, Supplier<SocketAddress> socketAddressSupplier) {
        this.clientOptions = clientOptions;
        this.bootstrap = bootstrap;
        this.timer = timer;
        this.reconnectWorkers = reconnectWorkers;
        this.socketAddressSupplier = socketAddressSupplier;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        logger.debug("{} userEventTriggered({}, {})", new Object[]{this.logPrefix, ctx, evt});
        if (evt instanceof ConnectionEvents.PrepareClose) {
            ConnectionEvents.PrepareClose prepareClose = (ConnectionEvents.PrepareClose)evt;
            this.setListenOnChannelInactive(false);
            this.setReconnectSuspended(true);
            prepareClose.getPrepareCloseFuture().set((Object)true);
            if (this.currentFuture != null && !this.currentFuture.isDone()) {
                this.currentFuture.cancel(true);
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("{} channelActive({})", (Object)this.logPrefix, (Object)ctx);
        this.channel = ctx.channel();
        this.attempts = 0;
        this.remoteAddress = this.channel.remoteAddress();
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("{} channelInactive({})", (Object)this.logPrefix, (Object)ctx);
        this.channel = null;
        if (this.listenOnChannelInactive && !this.reconnectSuspended) {
            RedisChannelHandler channelHandler = (RedisChannelHandler)ctx.pipeline().get(RedisChannelHandler.class);
            if (channelHandler != null) {
                this.timeout = channelHandler.getTimeout();
                this.timeoutUnit = channelHandler.getTimeoutUnit();
            }
            this.scheduleReconnect();
        } else {
            logger.debug("{} Reconnect scheduling disabled", (Object)this.logPrefix(), (Object)ctx);
            logger.debug("");
        }
        super.channelInactive(ctx);
    }

    public void scheduleReconnect() {
        logger.debug("{} scheduleReconnect()", (Object)this.logPrefix);
        if (!this.isEventLoopGroupActive()) {
            logger.debug("isEventLoopGroupActive() == false");
            return;
        }
        if (this.channel == null || !this.channel.isActive()) {
            if (this.attempts < 14) {
                ++this.attempts;
            }
            int timeout = 2 << this.attempts;
            this.timer.newTimeout(new TimerTask(){

                public void run(final Timeout timeout) throws Exception {
                    if (!ConnectionWatchdog.this.isEventLoopGroupActive()) {
                        logger.debug("isEventLoopGroupActive() == false");
                        return;
                    }
                    if (ConnectionWatchdog.this.reconnectWorkers != null) {
                        ConnectionWatchdog.this.run(timeout);
                        return;
                    }
                    ConnectionWatchdog.this.reconnectWorkers.submit((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            ConnectionWatchdog.this.run(timeout);
                            return null;
                        }
                    });
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        } else {
            logger.debug("{} Skipping scheduleReconnect() because I have an active channel", (Object)this.logPrefix);
        }
    }

    public void run(Timeout timeout) throws Exception {
        block6: {
            if (!this.isEventLoopGroupActive()) {
                logger.debug("isEventLoopGroupActive() == false");
                return;
            }
            boolean shouldLog = this.shouldLog();
            InternalLogLevel infoLevel = InternalLogLevel.INFO;
            InternalLogLevel warnLevel = InternalLogLevel.WARN;
            if (shouldLog) {
                this.lastReconnectionLogging = System.currentTimeMillis();
            } else {
                warnLevel = InternalLogLevel.DEBUG;
                infoLevel = InternalLogLevel.DEBUG;
            }
            try {
                this.reconnect(infoLevel, warnLevel);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            catch (Exception e) {
                logger.log(warnLevel, "Cannot connect: {}", (Object)e.toString());
                if (this.isReconnectSuspended()) break block6;
                this.scheduleReconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(InternalLogLevel infoLevel, InternalLogLevel warnLevel) throws Exception {
        block17: {
            logger.log(infoLevel, "Reconnecting, last destination was " + this.remoteAddress);
            if (this.socketAddressSupplier != null) {
                try {
                    this.remoteAddress = (SocketAddress)this.socketAddressSupplier.get();
                }
                catch (RuntimeException e) {
                    logger.log(warnLevel, "Cannot retrieve the current address from socketAddressSupplier: " + e.toString() + ", reusing old address " + this.remoteAddress);
                }
            }
            try {
                long timeLeft = this.timeoutUnit.toNanos(this.timeout);
                long start = System.nanoTime();
                this.currentFuture = this.bootstrap.connect(this.remoteAddress);
                if (!this.currentFuture.await(timeLeft, TimeUnit.NANOSECONDS)) {
                    if (this.currentFuture.isCancellable()) {
                        this.currentFuture.cancel(true);
                    }
                    throw new TimeoutException("Reconnection attempt exceeded timeout of " + this.timeout + " " + (Object)((Object)this.timeoutUnit));
                }
                this.currentFuture.sync();
                RedisChannelInitializer channelInitializer = (RedisChannelInitializer)this.currentFuture.channel().pipeline().get(RedisChannelInitializer.class);
                CommandHandler commandHandler = (CommandHandler)this.currentFuture.channel().pipeline().get(CommandHandler.class);
                if (channelInitializer == null) {
                    logger.warn("Reconnection attempt without a RedisChannelInitializer in the channel pipeline");
                    this.closeChannel();
                    return;
                }
                if (commandHandler == null) {
                    logger.warn("Reconnection attempt without a CommandHandler in the channel pipeline");
                    this.closeChannel();
                    return;
                }
                try {
                    channelInitializer.channelInitialized().get(Math.max(0L, timeLeft -= System.nanoTime() - start), TimeUnit.NANOSECONDS);
                    logger.log(infoLevel, "Reconnected to " + this.remoteAddress);
                }
                catch (TimeoutException e) {
                    channelInitializer.channelInitialized().cancel(true);
                }
                catch (Exception e) {
                    if (this.clientOptions.isCancelCommandsOnReconnectFailure()) {
                        commandHandler.reset();
                    }
                    if (this.clientOptions.isSuspendReconnectOnProtocolFailure()) {
                        logger.error("Cannot initialize channel. Disabling autoReconnect", (Throwable)e);
                        this.setReconnectSuspended(true);
                        break block17;
                    }
                    logger.error("Cannot initialize channel.", (Throwable)e);
                    throw e;
                }
            }
            finally {
                this.currentFuture = null;
            }
        }
    }

    private void closeChannel() {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }

    private boolean isEventLoopGroupActive() {
        if (this.bootstrap.group().isShutdown() || this.bootstrap.group().isTerminated() || this.bootstrap.group().isShuttingDown()) {
            return false;
        }
        return this.reconnectWorkers == null || !this.reconnectWorkers.isShutdown() && !this.reconnectWorkers.isTerminated() && !this.reconnectWorkers.isShuttingDown();
    }

    private boolean shouldLog() {
        long quietUntil = this.lastReconnectionLogging + LOGGING_QUIET_TIME_MS;
        return quietUntil <= System.currentTimeMillis();
    }

    @Deprecated
    public void setReconnect(boolean reconnect) {
        this.setListenOnChannelInactive(reconnect);
    }

    public void setListenOnChannelInactive(boolean listenOnChannelInactive) {
        this.listenOnChannelInactive = listenOnChannelInactive;
    }

    public boolean isListenOnChannelInactive() {
        return this.listenOnChannelInactive;
    }

    public boolean isReconnectSuspended() {
        return this.reconnectSuspended;
    }

    public void setReconnectSuspended(boolean reconnectSuspended) {
        this.reconnectSuspended = reconnectSuspended;
    }

    private String logPrefix() {
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('[').append(ChannelLogDescriptor.logDescriptor(this.channel)).append(']');
        this.logPrefix = buffer.toString();
        return this.logPrefix;
    }
}

