/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

@ChannelHandler.Sharable
class ConnectionEventTrigger
extends ChannelInboundHandlerAdapter {
    private ConnectionEvents connectionEvents;
    private RedisChannelHandler<?, ?> connection;

    public ConnectionEventTrigger(ConnectionEvents connectionEvents, RedisChannelHandler<?, ?> connection) {
        this.connectionEvents = connectionEvents;
        this.connection = connection;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.connectionEvents.fireEventRedisConnected(this.connection);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.connectionEvents.fireEventRedisDisconnected(this.connection);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.connectionEvents.fireEventRedisExceptionCaught(this.connection, cause);
        super.exceptionCaught(ctx, cause);
    }
}

