/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.metrics;

import com.lambdaworks.redis.internal.LettuceClassUtils;
import com.lambdaworks.redis.metrics.CommandLatencyCollector;
import com.lambdaworks.redis.metrics.CommandLatencyCollectorOptions;
import com.lambdaworks.redis.metrics.CommandLatencyId;
import com.lambdaworks.redis.metrics.CommandMetrics;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import io.netty.channel.local.LocalAddress;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;
import org.LatencyUtils.PauseDetector;
import org.LatencyUtils.SimplePauseDetector;

public class DefaultCommandLatencyCollector
implements CommandLatencyCollector {
    private static final AtomicReferenceFieldUpdater<DefaultCommandLatencyCollector, PauseDetectorWrapper> PAUSE_DETECTOR_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultCommandLatencyCollector.class, PauseDetectorWrapper.class, "pauseDetectorWrapper");
    private static final boolean LATENCY_UTILS_AVAILABLE = LettuceClassUtils.isPresent("org.LatencyUtils.PauseDetector");
    private static final boolean HDR_UTILS_AVAILABLE = LettuceClassUtils.isPresent("org.HdrHistogram.Histogram");
    private static final PauseDetectorWrapper GLOBAL_PAUSE_DETECTOR = PauseDetectorWrapper.create();
    private static final long MIN_LATENCY = 1000L;
    private static final long MAX_LATENCY = TimeUnit.MINUTES.toNanos(5L);
    private final CommandLatencyCollectorOptions options;
    private volatile PauseDetectorWrapper pauseDetectorWrapper;
    private final AtomicReference<Map<CommandLatencyId, Latencies>> latencyMetricsRef = new AtomicReference<ConcurrentHashMap<CommandLatencyId, Latencies>>(DefaultCommandLatencyCollector.createNewLatencyMap());
    private volatile boolean stopped;

    public DefaultCommandLatencyCollector(CommandLatencyCollectorOptions options) {
        this.options = options;
    }

    @Override
    public void recordCommandLatency(SocketAddress local, SocketAddress remote, ProtocolKeyword commandType, long firstResponseLatency, long completionLatency) {
        if (!this.isEnabled()) {
            return;
        }
        Latencies latencies = this.latencyMetricsRef.get().computeIfAbsent(this.createId(local, remote, commandType), id -> {
            if (PAUSE_DETECTOR_UPDATER.get(this) == null && PAUSE_DETECTOR_UPDATER.compareAndSet(this, null, GLOBAL_PAUSE_DETECTOR)) {
                PAUSE_DETECTOR_UPDATER.get(this).retain();
            }
            PauseDetector pauseDetector = ((DefaultPauseDetectorWrapper)PAUSE_DETECTOR_UPDATER.get(this)).getPauseDetector();
            if (this.options.resetLatenciesAfterEvent()) {
                return new Latencies(pauseDetector);
            }
            return new CummulativeLatencies(pauseDetector);
        });
        latencies.firstResponse.recordLatency(this.rangify(firstResponseLatency));
        latencies.completion.recordLatency(this.rangify(completionLatency));
    }

    private CommandLatencyId createId(SocketAddress local, SocketAddress remote, ProtocolKeyword commandType) {
        return CommandLatencyId.create(this.options.localDistinction() ? local : LocalAddress.ANY, remote, commandType);
    }

    private long rangify(long latency) {
        return Math.max(1000L, Math.min(MAX_LATENCY, latency));
    }

    @Override
    public boolean isEnabled() {
        return this.options.isEnabled() && !this.stopped;
    }

    @Override
    public void shutdown() {
        Map<CommandLatencyId, Latencies> latenciesMap;
        this.stopped = true;
        PauseDetectorWrapper pauseDetectorWrapper = PAUSE_DETECTOR_UPDATER.get(this);
        if (pauseDetectorWrapper != null && PAUSE_DETECTOR_UPDATER.compareAndSet(this, pauseDetectorWrapper, null)) {
            pauseDetectorWrapper.release();
        }
        if (this.latencyMetricsRef.compareAndSet(latenciesMap = this.latencyMetricsRef.get(), Collections.emptyMap())) {
            latenciesMap.values().forEach(Latencies::stop);
        }
    }

    @Override
    public Map<CommandLatencyId, CommandMetrics> retrieveMetrics() {
        Map<CommandLatencyId, Latencies> metricsToUse;
        Map<CommandLatencyId, Latencies> latenciesMap = this.latencyMetricsRef.get();
        if (this.options.resetLatenciesAfterEvent()) {
            metricsToUse = latenciesMap;
            this.latencyMetricsRef.set(DefaultCommandLatencyCollector.createNewLatencyMap());
            metricsToUse.values().forEach(Latencies::stop);
        } else {
            metricsToUse = new HashMap<CommandLatencyId, Latencies>(latenciesMap);
        }
        return this.getMetrics(metricsToUse);
    }

    private Map<CommandLatencyId, CommandMetrics> getMetrics(Map<CommandLatencyId, Latencies> latencyMetrics) {
        TreeMap<CommandLatencyId, CommandMetrics> result = new TreeMap<CommandLatencyId, CommandMetrics>();
        for (Map.Entry<CommandLatencyId, Latencies> entry : latencyMetrics.entrySet()) {
            Latencies latencies = entry.getValue();
            Histogram firstResponse = latencies.getFirstResponseHistogram();
            Histogram completion = latencies.getCompletionHistogram();
            if (firstResponse.getTotalCount() == 0L && completion.getTotalCount() == 0L) continue;
            CommandMetrics.CommandLatency firstResponseLatency = this.getMetric(firstResponse);
            CommandMetrics.CommandLatency completionLatency = this.getMetric(completion);
            CommandMetrics metrics = new CommandMetrics(firstResponse.getTotalCount(), this.options.targetUnit(), firstResponseLatency, completionLatency);
            result.put(entry.getKey(), metrics);
        }
        return result;
    }

    private CommandMetrics.CommandLatency getMetric(Histogram histogram) {
        Map<Double, Long> percentiles = this.getPercentiles(histogram);
        TimeUnit timeUnit = this.options.targetUnit();
        return new CommandMetrics.CommandLatency(timeUnit.convert(histogram.getMinValue(), TimeUnit.NANOSECONDS), timeUnit.convert(histogram.getMaxValue(), TimeUnit.NANOSECONDS), percentiles);
    }

    private Map<Double, Long> getPercentiles(Histogram histogram) {
        TreeMap<Double, Long> percentiles = new TreeMap<Double, Long>();
        for (double targetPercentile : this.options.targetPercentiles()) {
            percentiles.put(targetPercentile, this.options.targetUnit().convert(histogram.getValueAtPercentile(targetPercentile), TimeUnit.NANOSECONDS));
        }
        return percentiles;
    }

    public static boolean isAvailable() {
        return LATENCY_UTILS_AVAILABLE && HDR_UTILS_AVAILABLE;
    }

    private static ConcurrentHashMap<CommandLatencyId, Latencies> createNewLatencyMap() {
        return new ConcurrentHashMap<CommandLatencyId, Latencies>(CommandType.values().length);
    }

    public static CommandLatencyCollector disabled() {
        return new CommandLatencyCollector(){

            @Override
            public void recordCommandLatency(SocketAddress local, SocketAddress remote, ProtocolKeyword commandType, long firstResponseLatency, long completionLatency) {
            }

            @Override
            public void shutdown() {
            }

            @Override
            public Map<CommandLatencyId, CommandMetrics> retrieveMetrics() {
                return Collections.emptyMap();
            }

            @Override
            public boolean isEnabled() {
                return false;
            }
        };
    }

    static class DefaultPauseDetectorWrapper
    implements PauseDetectorWrapper {
        private static final AtomicLong instanceCounter = new AtomicLong();
        private final AtomicLong counter = new AtomicLong();
        private volatile PauseDetector pauseDetector;

        DefaultPauseDetectorWrapper() {
        }

        PauseDetector getPauseDetector() {
            while (this.pauseDetector == null) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return this.pauseDetector;
                }
            }
            return this.pauseDetector;
        }

        @Override
        public void retain() {
            if (this.counter.incrementAndGet() == 1L) {
                if (instanceCounter.getAndIncrement() > 0L) {
                    InternalLogger instance = InternalLoggerFactory.getInstance(this.getClass());
                    instance.info("Initialized PauseDetectorWrapper more than once.");
                }
                this.pauseDetector = new SimplePauseDetector(TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(10L), 3);
                Runtime.getRuntime().addShutdownHook(new Thread("ShutdownHook for SimplePauseDetector"){

                    @Override
                    public void run() {
                        if (pauseDetector != null) {
                            pauseDetector.shutdown();
                        }
                    }
                });
            }
        }

        @Override
        public void release() {
            if (this.counter.decrementAndGet() == 0L) {
                instanceCounter.decrementAndGet();
                this.pauseDetector.shutdown();
                this.pauseDetector = null;
            }
        }
    }

    static interface PauseDetectorWrapper {
        public static final PauseDetectorWrapper NO_OP = new PauseDetectorWrapper(){

            @Override
            public void release() {
            }

            @Override
            public void retain() {
            }
        };

        public static PauseDetectorWrapper create() {
            if (HDR_UTILS_AVAILABLE && LATENCY_UTILS_AVAILABLE) {
                return new DefaultPauseDetectorWrapper();
            }
            return NO_OP;
        }

        public void retain();

        public void release();
    }

    private static class CummulativeLatencies
    extends Latencies {
        private final Histogram firstResponse = Latencies.access$000(this).getIntervalHistogram();
        private final Histogram completion = Latencies.access$100(this).getIntervalHistogram();

        CummulativeLatencies(PauseDetector pauseDetector) {
            super(pauseDetector);
        }

        @Override
        public Histogram getFirstResponseHistogram() {
            this.firstResponse.add((AbstractHistogram)super.getFirstResponseHistogram());
            return this.firstResponse;
        }

        @Override
        public Histogram getCompletionHistogram() {
            this.completion.add((AbstractHistogram)super.getFirstResponseHistogram());
            return this.completion;
        }
    }

    private static class Latencies {
        private final LatencyStats firstResponse;
        private final LatencyStats completion;

        Latencies(PauseDetector pauseDetector) {
            this.firstResponse = LatencyStats.Builder.create().pauseDetector(pauseDetector).build();
            this.completion = LatencyStats.Builder.create().pauseDetector(pauseDetector).build();
        }

        public Histogram getFirstResponseHistogram() {
            return this.firstResponse.getIntervalHistogram();
        }

        public Histogram getCompletionHistogram() {
            return this.completion.getIntervalHistogram();
        }

        public void stop() {
            this.firstResponse.stop();
            this.completion.stop();
        }
    }
}

