/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import java.util.ArrayList;
import java.util.List;

public class MigrateArgs<K> {
    private boolean copy = false;
    private boolean replace = false;
    List<K> keys = new ArrayList<K>();

    public MigrateArgs<K> copy() {
        this.copy = true;
        return this;
    }

    public MigrateArgs<K> replace() {
        this.replace = true;
        return this;
    }

    public MigrateArgs<K> key(K key) {
        LettuceAssert.notNull(key, "Key must not be null");
        this.keys.add(key);
        return this;
    }

    @SafeVarargs
    public final MigrateArgs<K> keys(K ... keys) {
        LettuceAssert.notEmpty(keys, "Keys must not be empty");
        for (K key : keys) {
            this.keys.add(key);
        }
        return this;
    }

    public MigrateArgs<K> keys(Iterable<K> keys) {
        LettuceAssert.notNull(keys, "Keys must not be null");
        for (K key : keys) {
            this.keys.add(key);
        }
        return this;
    }

    public <V> void build(CommandArgs<K, V> args) {
        if (this.copy) {
            args.add(CommandKeyword.COPY);
        }
        if (this.replace) {
            args.add(CommandKeyword.REPLACE);
        }
        if (this.keys.size() > 1) {
            args.add(CommandType.KEYS);
            args.addKeys((Iterable<K>)this.keys);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K> MigrateArgs<K> copy() {
            return new MigrateArgs().copy();
        }

        public static <K> MigrateArgs<K> replace() {
            return new MigrateArgs().replace();
        }

        public static <K> MigrateArgs<K> key(K key) {
            return new MigrateArgs<K>().key(key);
        }

        @SafeVarargs
        public static <K> MigrateArgs<K> keys(K ... keys) {
            return new MigrateArgs<K>().keys(keys);
        }

        public static <K> MigrateArgs<K> keys(Iterable<K> keys) {
            return new MigrateArgs<K>().keys(keys);
        }
    }
}

