/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.sentinel;

import com.lambdaworks.redis.KillArgs;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.RedisSentinelAsyncConnection;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.AsyncCommand;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.sentinel.SentinelCommandBuilder;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import com.lambdaworks.redis.sentinel.api.async.RedisSentinelAsyncCommands;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class RedisSentinelAsyncCommandsImpl<K, V>
implements RedisSentinelAsyncCommands<K, V>,
RedisSentinelAsyncConnection<K, V> {
    private final SentinelCommandBuilder<K, V> commandBuilder;
    private final StatefulConnection<K, V> connection;

    public RedisSentinelAsyncCommandsImpl(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        this.connection = connection;
        this.commandBuilder = new SentinelCommandBuilder<K, V>(codec);
    }

    @Override
    public RedisFuture<SocketAddress> getMasterAddrByName(K key) {
        Command<K, V, List<V>> cmd = this.commandBuilder.getMasterAddrByKey(key);
        AsyncCommand<K, V, List<V>> future = this.dispatch(cmd);
        final AtomicReference ref = new AtomicReference();
        AsyncCommand convert = new AsyncCommand<K, V, SocketAddress>(cmd){

            @Override
            protected void completeResult() {
                this.complete(ref.get());
            }
        };
        future.whenComplete((list, t) -> {
            if (t != null) {
                convert.completeExceptionally((Throwable)t);
                return;
            }
            if (!list.isEmpty()) {
                LettuceAssert.isTrue(list.size() == 2, "List must contain exact 2 entries (Hostname, Port)");
                String hostname = (String)list.get(0);
                String port = (String)list.get(1);
                ref.set(new InetSocketAddress(hostname, Integer.parseInt(port)));
            }
            convert.complete();
        });
        return convert;
    }

    @Override
    public RedisFuture<List<Map<K, V>>> masters() {
        return this.dispatch(this.commandBuilder.masters());
    }

    @Override
    public RedisFuture<Map<K, V>> master(K key) {
        return this.dispatch(this.commandBuilder.master(key));
    }

    @Override
    public RedisFuture<List<Map<K, V>>> slaves(K key) {
        return this.dispatch(this.commandBuilder.slaves(key));
    }

    @Override
    public RedisFuture<Long> reset(K key) {
        return this.dispatch(this.commandBuilder.reset(key));
    }

    @Override
    public RedisFuture<String> failover(K key) {
        return this.dispatch(this.commandBuilder.failover(key));
    }

    @Override
    public RedisFuture<String> monitor(K key, String ip, int port, int quorum) {
        return this.dispatch(this.commandBuilder.monitor(key, ip, port, quorum));
    }

    @Override
    public RedisFuture<String> set(K key, String option, V value) {
        return this.dispatch(this.commandBuilder.set(key, option, value));
    }

    @Override
    public RedisFuture<String> remove(K key) {
        return this.dispatch(this.commandBuilder.remove(key));
    }

    @Override
    public RedisFuture<String> ping() {
        return this.dispatch(this.commandBuilder.ping());
    }

    @Override
    public RedisFuture<K> clientGetname() {
        return this.dispatch(this.commandBuilder.clientGetname());
    }

    @Override
    public RedisFuture<String> clientSetname(K name) {
        return this.dispatch(this.commandBuilder.clientSetname(name));
    }

    @Override
    public RedisFuture<String> clientKill(String addr) {
        return this.dispatch(this.commandBuilder.clientKill(addr));
    }

    @Override
    public RedisFuture<Long> clientKill(KillArgs killArgs) {
        return this.dispatch(this.commandBuilder.clientKill(killArgs));
    }

    @Override
    public RedisFuture<String> clientPause(long timeout) {
        return this.dispatch(this.commandBuilder.clientPause(timeout));
    }

    @Override
    public RedisFuture<String> clientList() {
        return this.dispatch(this.commandBuilder.clientList());
    }

    @Override
    public RedisFuture<String> info() {
        return this.dispatch(this.commandBuilder.info());
    }

    @Override
    public RedisFuture<String> info(String section) {
        return this.dispatch(this.commandBuilder.info(section));
    }

    public <T> AsyncCommand<K, V, T> dispatch(RedisCommand<K, V, T> cmd) {
        return this.connection.dispatch(new AsyncCommand<K, V, T>(cmd));
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public StatefulRedisSentinelConnection<K, V> getStatefulConnection() {
        return (StatefulRedisSentinelConnection)this.connection;
    }
}

