/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.ConnectionEventTrigger;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.ExceptionFactory;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisChannelInitializerImpl;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.event.connection.ConnectedEvent;
import com.lambdaworks.redis.event.connection.ConnectionActivatedEvent;
import com.lambdaworks.redis.event.connection.DisconnectedEvent;
import com.lambdaworks.redis.protocol.AsyncCommand;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.Timeout;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class PlainChannelInitializer
extends ChannelInitializer<Channel>
implements RedisChannelInitializer {
    static final Supplier<AsyncCommand<?, ?, ?>> NO_PING = () -> null;
    private final List<ChannelHandler> handlers;
    private final Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier;
    private final ClientResources clientResources;
    private final long timeout;
    private final TimeUnit timeUnit;
    private volatile CompletableFuture<Boolean> initializedFuture = new CompletableFuture();

    PlainChannelInitializer(Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier, List<ChannelHandler> handlers, ClientResources clientResources, long timeout, TimeUnit timeUnit) {
        this.pingCommandSupplier = pingCommandSupplier;
        this.handlers = handlers;
        this.clientResources = clientResources;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    protected void initChannel(Channel channel) throws Exception {
        if (channel.pipeline().get("channelActivator") == null) {
            channel.pipeline().addLast("channelActivator", (ChannelHandler)new RedisChannelInitializerImpl(){
                private AsyncCommand<?, ?, ?> pingCommand;

                @Override
                public CompletableFuture<Boolean> channelInitialized() {
                    return PlainChannelInitializer.this.initializedFuture;
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    PlainChannelInitializer.this.clientResources.eventBus().publish(new DisconnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                    if (!PlainChannelInitializer.this.initializedFuture.isDone()) {
                        PlainChannelInitializer.this.initializedFuture.completeExceptionally(new RedisConnectionException("Connection closed prematurely"));
                    }
                    PlainChannelInitializer.this.initializedFuture = new CompletableFuture();
                    this.pingCommand = null;
                    super.channelInactive(ctx);
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof ConnectionEvents.Close && ctx.channel().isOpen()) {
                        ctx.channel().close();
                    }
                    if (evt instanceof ConnectionEvents.Activated && !PlainChannelInitializer.this.initializedFuture.isDone()) {
                        PlainChannelInitializer.this.initializedFuture.complete(true);
                        PlainChannelInitializer.this.clientResources.eventBus().publish(new ConnectionActivatedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                    }
                    super.userEventTriggered(ctx, evt);
                }

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    PlainChannelInitializer.this.clientResources.eventBus().publish(new ConnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                    if (PlainChannelInitializer.this.pingCommandSupplier != NO_PING) {
                        this.pingCommand = (AsyncCommand)PlainChannelInitializer.this.pingCommandSupplier.get();
                        PlainChannelInitializer.pingBeforeActivate(this.pingCommand, PlainChannelInitializer.this.initializedFuture, ctx, PlainChannelInitializer.this.clientResources, PlainChannelInitializer.this.timeout, PlainChannelInitializer.this.timeUnit);
                    } else {
                        super.channelActive(ctx);
                    }
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (!PlainChannelInitializer.this.initializedFuture.isDone()) {
                        PlainChannelInitializer.this.initializedFuture.completeExceptionally(cause);
                    }
                    super.exceptionCaught(ctx, cause);
                }
            });
        }
        for (ChannelHandler handler : this.handlers) {
            PlainChannelInitializer.removeIfExists(channel.pipeline(), handler.getClass());
            channel.pipeline().addLast(new ChannelHandler[]{handler});
        }
        this.clientResources.nettyCustomizer().afterChannelInitialized(channel);
    }

    static void pingBeforeActivate(AsyncCommand<?, ?, ?> cmd, CompletableFuture<Boolean> initializedFuture, ChannelHandlerContext ctx, ClientResources clientResources, long timeout, TimeUnit timeUnit) throws Exception {
        ctx.fireUserEventTriggered((Object)new ConnectionEvents.PingBeforeActivate(cmd));
        Runnable timeoutGuard = () -> {
            if (cmd.isDone() || initializedFuture.isDone()) {
                return;
            }
            initializedFuture.completeExceptionally(ExceptionFactory.createTimeoutException("Cannot initialize channel (PING before activate)", timeout, timeUnit));
        };
        Timeout timeoutHandle = clientResources.timer().newTimeout(t -> {
            if (clientResources.eventExecutorGroup().isShuttingDown()) {
                timeoutGuard.run();
                return;
            }
            clientResources.eventExecutorGroup().submit(timeoutGuard);
        }, timeout, timeUnit);
        cmd.whenComplete((o, throwable) -> {
            timeoutHandle.cancel();
            if (throwable == null) {
                ctx.fireChannelActive();
                initializedFuture.complete(true);
            } else {
                initializedFuture.completeExceptionally((Throwable)throwable);
            }
        });
    }

    static void removeIfExists(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerClass) {
        ChannelHandler channelHandler = pipeline.get(handlerClass);
        if (channelHandler != null) {
            pipeline.remove(channelHandler);
        }
    }

    @Override
    public CompletableFuture<Boolean> channelInitialized() {
        return this.initializedFuture;
    }
}

