/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;

public class XClaimArgs {
    long minIdleTime;
    private Long idle;
    private Long time;
    private Long retrycount;
    private boolean force;

    public XClaimArgs minIdleTime(long milliseconds) {
        this.minIdleTime = milliseconds;
        return this;
    }

    public XClaimArgs minIdleTime(Duration minIdleTime) {
        LettuceAssert.notNull(minIdleTime, "Min idle time must not be null");
        return this.minIdleTime(minIdleTime.toMillis());
    }

    public XClaimArgs idle(long milliseconds) {
        this.idle = milliseconds;
        return this;
    }

    public XClaimArgs idle(Duration idleTime) {
        LettuceAssert.notNull(idleTime, "Idle time must not be null");
        return this.idle(idleTime.toMillis());
    }

    public XClaimArgs time(long millisecondsUnixTime) {
        this.time = millisecondsUnixTime;
        return this;
    }

    public XClaimArgs time(TemporalAccessor timestamp) {
        LettuceAssert.notNull(timestamp, "Timestamp must not be null");
        return this.time(Instant.from(timestamp).toEpochMilli());
    }

    public XClaimArgs retryCount(long retrycount) {
        this.retrycount = retrycount;
        return this;
    }

    public XClaimArgs force() {
        return this.force(true);
    }

    public XClaimArgs force(boolean force) {
        this.force = force;
        return this;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.idle != null) {
            args.add(CommandKeyword.IDLE).add(this.idle);
        }
        if (this.time != null) {
            args.add(CommandType.TIME).add(this.time);
        }
        if (this.retrycount != null) {
            args.add(CommandKeyword.RETRYCOUNT).add(this.retrycount);
        }
        if (this.force) {
            args.add(CommandKeyword.FORCE);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static XClaimArgs minIdleTime(long milliseconds) {
            return new XClaimArgs().minIdleTime(milliseconds);
        }

        public static XClaimArgs minIdleTime(Duration minIdleTime) {
            LettuceAssert.notNull(minIdleTime, "Min idle time must not be null");
            return Builder.minIdleTime(minIdleTime.toMillis());
        }
    }
}

