/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.api.async;

import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.ScanCursor;
import com.lambdaworks.redis.StreamScanCursor;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterAsyncConnection;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.async.AsyncNodeSelection;
import com.lambdaworks.redis.cluster.api.async.RedisClusterAsyncCommands;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.output.KeyStreamingChannel;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public interface RedisAdvancedClusterAsyncCommands<K, V>
extends RedisClusterAsyncCommands<K, V>,
RedisAdvancedClusterAsyncConnection<K, V> {
    @Override
    public RedisClusterAsyncCommands<K, V> getConnection(String var1);

    @Override
    public RedisClusterAsyncCommands<K, V> getConnection(String var1, int var2);

    @Override
    public StatefulRedisClusterConnection<K, V> getStatefulConnection();

    default public AsyncNodeSelection<K, V> masters() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.MASTER));
    }

    default public AsyncNodeSelection<K, V> slaves() {
        return this.readonly(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public AsyncNodeSelection<K, V> slaves(Predicate<RedisClusterNode> predicate) {
        return this.readonly(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public AsyncNodeSelection<K, V> all() {
        return this.nodes(redisClusterNode -> true);
    }

    public AsyncNodeSelection<K, V> readonly(Predicate<RedisClusterNode> var1);

    public AsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1);

    public AsyncNodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1, boolean var2);

    @Override
    public RedisFuture<Long> del(K ... var1);

    @Override
    public RedisFuture<Long> unlink(K ... var1);

    @Override
    public RedisFuture<Long> exists(K ... var1);

    @Override
    public RedisFuture<List<V>> mget(K ... var1);

    @Override
    public RedisFuture<String> mset(Map<K, V> var1);

    @Override
    public RedisFuture<Boolean> msetnx(Map<K, V> var1);

    @Override
    public RedisFuture<String> clientSetname(K var1);

    @Override
    public RedisFuture<String> flushall();

    @Override
    public RedisFuture<String> flushdb();

    @Override
    public RedisFuture<Long> dbsize();

    @Override
    public RedisFuture<List<K>> keys(K var1);

    @Override
    public RedisFuture<Long> keys(KeyStreamingChannel<K> var1, K var2);

    @Override
    public RedisFuture<V> randomkey();

    @Override
    public RedisFuture<String> scriptFlush();

    @Override
    public RedisFuture<String> scriptKill();

    @Override
    public RedisFuture<String> scriptLoad(V var1);

    @Override
    public void shutdown(boolean var1);

    @Override
    public RedisFuture<KeyScanCursor<K>> scan();

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanArgs var1);

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor var1, ScanArgs var2);

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor var1);

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> var1);

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> var1, ScanArgs var2);

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> var1, ScanCursor var2, ScanArgs var3);

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> var1, ScanCursor var2);

    @Override
    public RedisFuture<Long> touch(K ... var1);
}

