/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import java.nio.ByteBuffer;

public class ScoredValueOutput<K, V>
extends CommandOutput<K, V, ScoredValue<V>> {
    private V value;

    public ScoredValueOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.output = new ScoredValue<V>(score, this.value);
        this.value = null;
    }
}

