/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.resource.DnsResolver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class SocketAddressResolver {
    public static SocketAddress resolve(RedisURI redisURI, DnsResolver dnsResolver) {
        if (redisURI.getSocket() != null) {
            return redisURI.getResolvedAddress();
        }
        try {
            InetAddress[] inetAddress = dnsResolver.resolve(redisURI.getHost());
            if (inetAddress.length == 0) {
                return InetSocketAddress.createUnresolved(redisURI.getHost(), redisURI.getPort());
            }
            return new InetSocketAddress(inetAddress[0], redisURI.getPort());
        }
        catch (UnknownHostException e) {
            return redisURI.getResolvedAddress();
        }
    }
}

