/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitChat.rongcloud.rong.methods;

import cc.openkit.kitChat.rongcloud.rong.models.CodeSuccessResult;
import cc.openkit.kitChat.rongcloud.rong.models.GroupInfo;
import cc.openkit.kitChat.rongcloud.rong.models.GroupUserQueryResult;
import cc.openkit.kitChat.rongcloud.rong.models.ListGagGroupUserResult;
import cc.openkit.kitChat.rongcloud.rong.util.GsonUtil;
import cc.openkit.kitChat.rongcloud.rong.util.HostType;
import cc.openkit.kitChat.rongcloud.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Group {
    private static final String UTF8 = "UTF-8";
    private String appKey;
    private String appSecret;

    public Group(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public CodeSuccessResult create(String[] userId, String groupId, String groupName) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        if (groupName == null) {
            throw new IllegalArgumentException("Paramer 'groupName' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < userId.length; ++i) {
            String child = userId[i];
            sb.append("&userId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(groupName.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/create.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult sync(String userId, GroupInfo[] groupInfo) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (groupInfo == null) {
            throw new IllegalArgumentException("Paramer 'groupInfo' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId, UTF8));
        for (int i = 0; i < groupInfo.length; ++i) {
            GroupInfo child = groupInfo[i];
            sb.append("&group[" + child.getId() + "]=").append(URLEncoder.encode(child.getName(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/sync.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult refresh(String groupId, String groupName) throws Exception {
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        if (groupName == null) {
            throw new IllegalArgumentException("Paramer 'groupName' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(groupName.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/refresh.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult join(String[] userId, String groupId, String groupName) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        if (groupName == null) {
            throw new IllegalArgumentException("Paramer 'groupName' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < userId.length; ++i) {
            String child = userId[i];
            sb.append("&userId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(groupName.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/join.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public GroupUserQueryResult queryUser(String groupId) throws Exception {
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/user/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (GroupUserQueryResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), GroupUserQueryResult.class);
    }

    public CodeSuccessResult quit(String[] userId, String groupId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < userId.length; ++i) {
            String child = userId[i];
            sb.append("&userId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/quit.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult addGagUser(String userId, String groupId, String minute) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        if (minute == null) {
            throw new IllegalArgumentException("Paramer 'minute' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        sb.append("&minute=").append(URLEncoder.encode(minute.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/user/gag/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public ListGagGroupUserResult lisGagUser(String groupId) throws Exception {
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/user/gag/list.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ListGagGroupUserResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), ListGagGroupUserResult.class);
    }

    public CodeSuccessResult rollBackGagUser(String[] userId, String groupId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < userId.length; ++i) {
            String child = userId[i];
            sb.append("&userId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/user/gag/rollback.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public CodeSuccessResult dismiss(String userId, String groupId) throws Exception {
        if (userId == null) {
            throw new IllegalArgumentException("Paramer 'userId' is required");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Paramer 'groupId' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        sb.append("&groupId=").append(URLEncoder.encode(groupId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/group/dismiss.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }
}

