/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitChat.rongcloud.rong.methods;

import cc.openkit.kitChat.rongcloud.rong.models.CodeSuccessResult;
import cc.openkit.kitChat.rongcloud.rong.models.ListWordfilterResult;
import cc.openkit.kitChat.rongcloud.rong.util.GsonUtil;
import cc.openkit.kitChat.rongcloud.rong.util.HostType;
import cc.openkit.kitChat.rongcloud.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Wordfilter {
    private static final String UTF8 = "UTF-8";
    private String appKey;
    private String appSecret;

    public Wordfilter(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public CodeSuccessResult add(String word) throws Exception {
        if (word == null) {
            throw new IllegalArgumentException("Paramer 'word' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&word=").append(URLEncoder.encode(word.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/wordfilter/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }

    public ListWordfilterResult getList() throws Exception {
        StringBuilder sb = new StringBuilder();
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/wordfilter/list.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ListWordfilterResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), ListWordfilterResult.class);
    }

    public CodeSuccessResult delete(String word) throws Exception {
        if (word == null) {
            throw new IllegalArgumentException("Paramer 'word' is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&word=").append(URLEncoder.encode(word.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(HostType.API, this.appKey, this.appSecret, "/wordfilter/delete.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CodeSuccessResult)GsonUtil.fromJson(HttpUtil.returnResult(conn), CodeSuccessResult.class);
    }
}

