/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitJuhe.HuaFei.service;

import cc.openkit.common.KitUtil;
import cc.openkit.kitJuhe.HuaFei.config.HuafeiConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HuafeiService {
    public static RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).build();

    public static int telCheck(HuafeiConfig huafeiConfig, String phone, int cardnum) throws Exception {
        int error_code = 0;
        String result = HuafeiService.get(huafeiConfig.getTelCheckUrl().replace("*", cardnum + "").replace("!", phone), 0);
        error_code = JSONObject.fromObject((Object)result).getInt("error_code");
        return error_code;
    }

    public static String telQuery(HuafeiConfig huafeiConfig, String phone, int cardnum) throws Exception {
        String result = HuafeiService.get(huafeiConfig.getTelQueryUrl().replace("*", cardnum + "").replace("!", phone), 0);
        return result;
    }

    public static String onlineOrder(HuafeiConfig huafeiConfig, String phone, int cardnum, String orderid) throws Exception {
        String result = null;
        String sign = KitUtil.md5(huafeiConfig.getOpenId() + huafeiConfig.getKey() + phone + cardnum + orderid);
        result = HuafeiService.get(huafeiConfig.getOnlineUrl().replace("*", cardnum + "").replace("!", phone).replace("@", orderid).replace("$", sign), 0);
        return result;
    }

    public static String yuE(HuafeiConfig huafeiConfig) throws Exception {
        String timestamp = System.currentTimeMillis() / 1000L + "";
        String sign = KitUtil.md5(huafeiConfig.getOpenId() + huafeiConfig.getKey() + timestamp);
        String result = HuafeiService.get(huafeiConfig.getYueUrl().replace("%", timestamp).replace("$", sign), 0);
        return result;
    }

    public static String orderSta(HuafeiConfig huafeiConfig, String orderid) throws Exception {
        return HuafeiService.get(huafeiConfig.getOrderstaUrl().replace("!", orderid), 0);
    }

    public static String orderList(HuafeiConfig huafeiConfig) throws Exception {
        return HuafeiService.get(huafeiConfig.getOrderListUrl(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, int tts) throws Exception {
        if (tts > 3) {
            return null;
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String result = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            httpGet.setConfig(config);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                result = HuafeiService.ConvertStreamToString(resEntity.getContent(), "UTF-8");
            }
            EntityUtils.consume((HttpEntity)resEntity);
            String string = result;
            return string;
        }
        catch (IOException e) {
            String string = HuafeiService.get(url, tts++);
            return string;
        }
        finally {
            response.close();
            httpClient.close();
        }
    }

    public static String ConvertStreamToString(InputStream is, String charset) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(is, charset);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
        }
        return sb.toString();
    }
}

