/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitMemory.qiniu.service;

import cc.openkit.kitMemory.qiniu.config.QiniuConfig;
import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class QIniuService {
    public static String simpleVoucher(QiniuConfig qiniuConfig) throws Exception {
        String accessKey = qiniuConfig.getAccessKey();
        String secretKey = qiniuConfig.getSecretKey();
        String bucket = qiniuConfig.getBucket();
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        String upToken = auth.uploadToken(bucket);
        return upToken;
    }

    public static String reviseCoucher(QiniuConfig qiniuConfig) throws Exception {
        String accessKey = qiniuConfig.getAccessKey();
        String secretKey = qiniuConfig.getSecretKey();
        String bucket = qiniuConfig.getBucket();
        String key = qiniuConfig.getKey();
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        String upToken = auth.uploadToken(bucket, key);
        System.out.println(upToken);
        return upToken;
    }

    public static void uploadByFilePath(QiniuConfig qiniuConfig, String localFilePath) {
        Configuration cfg = new Configuration(Zone.zone0());
        UploadManager uploadManager = new UploadManager(cfg);
        String accessKey = qiniuConfig.getAccessKey();
        String secretKey = qiniuConfig.getSecretKey();
        String bucket = qiniuConfig.getBucket();
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        String upToken = auth.uploadToken(bucket);
        try {
            Response response = uploadManager.put(localFilePath, qiniuConfig.getKey(), upToken);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            System.out.println(putRet.key);
            System.out.println(putRet.hash);
        }
        catch (QiniuException ex) {
            System.out.println("\u4e0a\u4f20\u5931\u8d25\u4e86\uff0c\u51fa\u73b0\u5f02\u5e38\u4e86");
            Response r = ex.response;
            System.err.println(r.toString());
            try {
                System.err.println(r.bodyString());
            }
            catch (QiniuException qiniuException) {
                // empty catch block
            }
        }
    }

    public static void uploadByByteArray(QiniuConfig qiniuConfig, String bytes, String charsetName) {
        Configuration cfg = new Configuration(Zone.zone0());
        UploadManager uploadManager = new UploadManager(cfg);
        String accessKey = qiniuConfig.getAccessKey();
        String secretKey = qiniuConfig.getSecretKey();
        String bucket = qiniuConfig.getBucket();
        try {
            byte[] uploadBytes = bytes.getBytes(charsetName);
            Auth auth = Auth.create((String)accessKey, (String)secretKey);
            String upToken = auth.uploadToken(bucket);
            try {
                Response response = uploadManager.put(uploadBytes, qiniuConfig.getKey(), upToken);
                DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
                System.out.println(putRet.key);
                System.out.println(putRet.hash);
            }
            catch (QiniuException ex) {
                Response r = ex.response;
                System.err.println(r.toString());
                try {
                    System.err.println(r.bodyString());
                }
                catch (QiniuException qiniuException) {}
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void uploadByFileRecorder(QiniuConfig qiniuConfig, String bytes, String charsetName) {
        Configuration cfg = new Configuration(Zone.zone0());
        UploadManager uploadManager = new UploadManager(cfg);
        String accessKey = qiniuConfig.getAccessKey();
        String secretKey = qiniuConfig.getSecretKey();
        String bucket = qiniuConfig.getBucket();
        try {
            byte[] uploadBytes = bytes.getBytes(charsetName);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(uploadBytes);
            Auth auth = Auth.create((String)accessKey, (String)secretKey);
            String upToken = auth.uploadToken(bucket);
            try {
                Response response = uploadManager.put((InputStream)byteInputStream, qiniuConfig.getKey(), upToken, null, null);
                DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
                System.out.println(putRet.key);
                System.out.println(putRet.hash);
            }
            catch (QiniuException ex) {
                Response r = ex.response;
                System.err.println(r.toString());
                try {
                    System.err.println(r.bodyString());
                }
                catch (QiniuException qiniuException) {}
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

