/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitMessage.ucpaas.restDemo;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class SysConfig {
    private Properties props = new Properties();
    private static volatile SysConfig conf;

    private SysConfig() {
        this.loadConfigProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SysConfig getInstance() {
        if (conf != null) return conf;
        Class<SysConfig> clazz = SysConfig.class;
        synchronized (SysConfig.class) {
            if (conf != null) return conf;
            conf = new SysConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return conf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfigProps() {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/WEB-INF/classes/ucpaasconfig.properties");
            if (is == null) {
                is = this.getClass().getResourceAsStream("/ucpaasconfig.properties");
            }
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            this.props.load(reader);
            for (String key : this.props.stringPropertyNames()) {
                this.props.setProperty(key, this.props.getProperty(key));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getProperty(String key) {
        String tmp = this.props.getProperty(key);
        if (StringUtils.isNotEmpty((String)tmp)) {
            return tmp.trim();
        }
        return tmp;
    }

    public String getProperty(String key, String defaultValue) {
        String tmp = this.props.getProperty(key, defaultValue);
        if (StringUtils.isNotEmpty((String)tmp)) {
            return tmp.trim();
        }
        return tmp;
    }

    public int getPropertyInt(String key) {
        String tmp = this.props.getProperty(key);
        if (StringUtils.isNotEmpty((String)tmp)) {
            return Integer.parseInt(tmp.trim());
        }
        return 0;
    }

    public int getPropertyInt(String key, int defaultValue) {
        String tmp = this.props.getProperty(key);
        if (StringUtils.isNotEmpty((String)tmp)) {
            return Integer.parseInt(tmp.trim());
        }
        return defaultValue;
    }

    public long getPropertyLong(String key, long defaultValue) {
        String tmp = this.props.getProperty(key);
        if (StringUtils.isNotEmpty((String)tmp)) {
            return Integer.parseInt(tmp.trim());
        }
        return defaultValue;
    }
}

