/*
 * Decompiled with CFR 0.152.
 */
package cc.openkit.kitPay.weichart.service.impl;

import cc.openkit.kitPay.weichart.handler.PrepayIdRequestHandler;
import cc.openkit.kitPay.weichart.model.WeichartModel;
import cc.openkit.kitPay.weichart.service.WeixinPayService;
import cc.openkit.kitPay.weichart.util.Md5Util;
import cc.openkit.kitPay.weichart.util.WXUtil;
import cc.openkit.kitPay.weichart.util.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.JDOMException;

public class WeixinPayServiceImpl
implements WeixinPayService {
    @Override
    public Map<String, Object> getOrder(HttpServletRequest request, HttpServletResponse response, WeichartModel weichartModel, String totalFee, String out_trade_no, String notify_url) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (notify_url == null || "".equals(notify_url)) {
            notify_url = weichartModel.getNotifyUrl();
        }
        PrepayIdRequestHandler prepayReqHandler = new PrepayIdRequestHandler(request, response);
        int total_fee = (int)(Float.valueOf(totalFee).floatValue() * 100.0f);
        System.out.println("total:" + total_fee);
        System.out.println("total_fee:" + total_fee);
        prepayReqHandler.setParameter("appid", weichartModel.getAppId());
        prepayReqHandler.setParameter("body", weichartModel.getBody());
        prepayReqHandler.setParameter("mch_id", weichartModel.getMchId());
        String nonce_str = WXUtil.getNonceStr();
        prepayReqHandler.setParameter("nonce_str", nonce_str);
        prepayReqHandler.setParameter("notify_url", notify_url);
        prepayReqHandler.setParameter("out_trade_no", out_trade_no);
        System.out.println("IP:" + weichartModel.getSpbillCreateIp());
        prepayReqHandler.setParameter("spbill_create_ip", weichartModel.getSpbillCreateIp());
        System.out.println("prepayReqHandler:" + prepayReqHandler.getParameter("spbill_create_ip"));
        String timestamp = WXUtil.getTimeStamp();
        prepayReqHandler.setParameter("time_start", timestamp);
        System.out.println(String.valueOf(total_fee));
        prepayReqHandler.setParameter("total_fee", String.valueOf(total_fee));
        prepayReqHandler.setParameter("trade_type", "APP");
        prepayReqHandler.setParameter("sign", prepayReqHandler.createMD5Sign());
        prepayReqHandler.setGateUrl(weichartModel.getGateUrl());
        String prepayid = prepayReqHandler.sendPrepay();
        if (prepayid != null && !prepayid.equals("")) {
            String signs = "appid=" + weichartModel.getAppId() + "&noncestr=" + nonce_str + "&package=Sign=WXPay&partnerid=" + weichartModel.getPartnerId() + "&prepayid=" + prepayid + "&timestamp=" + timestamp + "&key=" + weichartModel.getAppKey();
            map.put("code", 0);
            map.put("info", "success");
            map.put("prepayid", prepayid);
            map.put("sign", Md5Util.MD5Encode(signs, "utf8").toUpperCase());
            map.put("appid", weichartModel.getAppId());
            map.put("timestamp", timestamp);
            map.put("noncestr", nonce_str);
            map.put("package", "Sign=WXPay");
            map.put("partnerid", weichartModel.getPartnerId());
        } else {
            map.put("code", 1);
            map.put("info", "\u83b7\u53d6prepayid\u5931\u8d25");
        }
        return map;
    }

    @Override
    public Map<String, String> getnotify(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        ServletInputStream inStream = request.getInputStream();
        ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outSteam.write(buffer, 0, len);
        }
        outSteam.close();
        inStream.close();
        String result = new String(outSteam.toByteArray(), "utf-8");
        System.out.println("\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u7ed3\u679c\uff1a" + result);
        Map map = null;
        try {
            map = XMLUtil.doXMLParse(result);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        System.out.println("=========:" + result);
        return map;
    }
}

