/*
 * Decompiled with CFR 0.152.
 */
package chapters.appenders.socket;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.StatusPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsolePluginClient {
    static String LONG_TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum lectus augue, pulvinar quis cursus nec, imperdiet nec ante. Cras sit amet arcu et enim adipiscing pellentesque. Suspendisse mi felis, dictum a lobortis nec, placerat in diam. Proin lobortis tortor at nunc facilisis aliquet. Praesent eget dignissim orci. Ut iaculis bibendum.";
    static String LOGGER_NAME = "com.acme.myapp.foo";
    static String UGLY_BETTY_LOGGER_NAME = "com.acme.myapp.UglyBetty";
    static long SLEEP = 1L;
    static long RUN_LENGTH = 200000L;

    public static void main(String[] args) throws Exception {
        String hostname = "localhost";
        int port = 4321;
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setRemoteHost(hostname);
        socketAppender.setPort(port);
        socketAppender.setIncludeCallerData(true);
        socketAppender.setReconnectionDelay(new Duration(10000L));
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        socketAppender.setContext((Context)lc);
        lc.reset();
        lc.getStatusManager().add((StatusListener)new OnConsoleStatusListener());
        socketAppender.start();
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.addAppender((Appender)socketAppender);
        Logger logger = LoggerFactory.getLogger((String)LOGGER_NAME);
        UglyBetty ub = new UglyBetty("ugly-betty-thread-234");
        ub.start();
        int i = 0;
        while ((long)i < RUN_LENGTH) {
            if (i % 3 == 0) {
                logger.warn(i + " is divisible by 3");
            } else {
                ConsolePluginClient.toto(logger, i);
            }
            Thread.sleep(SLEEP);
            ++i;
        }
        ub.join();
        StatusPrinter.print((Context)lc);
    }

    static void toto(Logger logger, int i) {
        logger.debug("this is message number " + i);
    }

    static class UglyBetty
    extends Thread {
        Logger logger = LoggerFactory.getLogger((String)UGLY_BETTY_LOGGER_NAME);

        public UglyBetty(String name) {
            super(name);
        }

        @Override
        public void run() {
            int i = 0;
            while ((long)i < RUN_LENGTH) {
                if (i % 23 == 0) {
                    this.logger.warn(LONG_TEXT);
                } else if (i % 47 == 0) {
                    this.logger.error("this is an exception", (Throwable)new Exception("test"));
                } else {
                    this.count(this.logger, i);
                }
                try {
                    Thread.sleep(SLEEP);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }

        void count(Logger logger, int i) {
            logger.debug("Betty counts to " + i);
        }
    }
}

