/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.sqlinxml;

import cn.dreampie.jaxb.JaxbKit;
import cn.dreampie.sqlinxml.SqlGroup;
import cn.dreampie.sqlinxml.SqlItem;
import cn.dreampie.sqlinxml.SqlRoot;
import com.google.common.collect.Maps;
import com.jfinal.log.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlKit {
    protected static final Logger LOG = Logger.getLogger(SqlKit.class);
    private static Map<String, String> sqlMap;

    public static String sql(String groupNameAndsqlId) {
        if (sqlMap == null) {
            throw new NullPointerException("SqlInXmlPlugin not start");
        }
        return sqlMap.get(groupNameAndsqlId);
    }

    static void clearSqlMap() {
        sqlMap.clear();
    }

    static void init() {
        sqlMap = new HashMap<String, String>();
        Enumeration<URL> baseURLs = null;
        try {
            baseURLs = SqlKit.class.getClassLoader().getResources("sql");
            if (baseURLs == null) {
                baseURLs = SqlKit.class.getClassLoader().getResources("");
            }
            URL url = null;
            while (baseURLs.hasMoreElements()) {
                url = baseURLs.nextElement();
                SqlKit.loadFilePath(url);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOG.debug("sqlMap" + sqlMap);
    }

    static void init(String ... paths) {
        sqlMap = new HashMap<String, String>();
        for (String path : paths) {
            if (path.startsWith("/")) {
                path = path + path.substring(1);
            }
            Enumeration<URL> baseURLs = null;
            try {
                baseURLs = SqlKit.class.getClassLoader().getResources(path);
                if (baseURLs == null) {
                    baseURLs = SqlKit.class.getClassLoader().getResources("");
                }
                URL url = null;
                while (baseURLs.hasMoreElements()) {
                    url = baseURLs.nextElement();
                    SqlKit.loadFilePath(url);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LOG.debug("sqlMap" + sqlMap);
    }

    private static void loadFilePath(URL baseURL) {
        if (baseURL != null) {
            String protocol = baseURL.getProtocol();
            String basePath = baseURL.getFile();
            if ("jar".equals(protocol)) {
                String[] pathurls = basePath.split("!/");
                try {
                    SqlKit.loadJarFileList(URLDecoder.decode(pathurls[0].replace("file:", ""), "UTF-8"), pathurls[1]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                SqlKit.loadFileList(basePath);
            }
        }
    }

    public static void loadFileList(String strPath) {
        ArrayList<File> files = new ArrayList<File>();
        File dir = new File(strPath);
        File[] dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith("sql") || pathname.getName().endsWith("sql.xml");
            }
        });
        if (dirs == null) {
            return;
        }
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].isDirectory()) {
                SqlKit.loadFileList(dirs[i].getAbsolutePath());
                continue;
            }
            if (!dirs[i].getName().endsWith("sql.xml")) continue;
            files.add(dirs[i]);
        }
        SqlKit.loadFiles(files);
    }

    private static void loadJarFileList(String filePath, String packageName) throws IOException {
        Map<Object, Object> sqlFiles = Maps.newHashMap();
        JarFile localJarFile = new JarFile(new File(filePath));
        sqlFiles = SqlKit.findInJar(localJarFile, packageName);
        SqlKit.loadStreamFiles(sqlFiles);
        localJarFile.close();
    }

    private static Map<String, InputStream> findInJar(JarFile localJarFile, String packageName) {
        HashMap sqlFiles = Maps.newHashMap();
        Enumeration<JarEntry> entries = localJarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String entryName = jarEntry.getName();
            if (jarEntry.isDirectory() || packageName != null && !entryName.startsWith(packageName) || !entryName.endsWith("sql.xml")) continue;
            sqlFiles.put(entryName.substring(entryName.lastIndexOf("/") + 1), SqlKit.class.getResourceAsStream(File.separator + entryName));
        }
        return sqlFiles;
    }

    private static void loadFiles(List<File> files) {
        for (File xmlfile : files) {
            SqlRoot root = (SqlRoot)JaxbKit.unmarshal((File)xmlfile, SqlRoot.class);
            for (SqlGroup sqlGroup : root.sqlGroups) {
                SqlKit.getSql(xmlfile.getName(), sqlGroup);
            }
        }
    }

    private static void loadStreamFiles(Map<String, InputStream> streams) {
        for (String filename : streams.keySet()) {
            SqlRoot root = (SqlRoot)JaxbKit.unmarshal((InputStream)streams.get(filename), SqlRoot.class);
            for (SqlGroup sqlGroup : root.sqlGroups) {
                SqlKit.getSql(filename, sqlGroup);
            }
        }
    }

    private static void getSql(String filename, SqlGroup sqlGroup) {
        String name = sqlGroup.name;
        if (name == null || name.trim().equals("")) {
            name = filename;
        }
        for (SqlItem sqlItem : sqlGroup.sqlItems) {
            sqlMap.put(name + "." + sqlItem.id, sqlItem.value);
        }
    }
}

