/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.pooled;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.pooled.DbConfig;
import cn.hutool.setting.Setting;

public class DbSetting {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private Setting setting;

    public DbSetting() {
        this(null);
    }

    public DbSetting(Setting setting) {
        this.setting = null == setting ? new Setting(DEFAULT_DB_CONFIG_PATH) : setting;
    }

    public DbConfig getDbConfig(String group) {
        Setting config = this.setting.getSetting(group);
        if (CollectionUtil.isEmpty(config)) {
            throw new DbRuntimeException("No Hutool pool config for group: [{}]", group);
        }
        DbConfig dbConfig = new DbConfig();
        String url = config.getAndRemoveStr(DSFactory.KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        dbConfig.setUrl(url);
        dbConfig.setUser(config.getAndRemoveStr(DSFactory.KEY_ALIAS_USER));
        dbConfig.setPass(config.getAndRemoveStr(DSFactory.KEY_ALIAS_PASSWORD));
        String driver = config.getAndRemoveStr(DSFactory.KEY_ALIAS_DRIVER);
        if (StrUtil.isNotBlank(driver)) {
            dbConfig.setDriver(driver);
        } else {
            dbConfig.setDriver(DbUtil.identifyDriver(url));
        }
        dbConfig.setInitialSize(this.setting.getInt("initialSize", group, 0));
        dbConfig.setMinIdle(this.setting.getInt("minIdle", group, 0));
        dbConfig.setMaxActive(this.setting.getInt("maxActive", group, 8));
        dbConfig.setMaxWait(this.setting.getLong("maxWait", group, 6000L));
        return dbConfig;
    }
}

