/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.InternalExcelUtil;
import cn.hutool.poi.excel.StyleSet;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelWriter
implements Closeable {
    private boolean isClosed;
    private Workbook workbook;
    private Sheet sheet;
    private File destFile;
    private AtomicInteger currentRow = new AtomicInteger(0);
    private Map<String, String> headerAlias;
    private StyleSet styleSet;

    public ExcelWriter() {
        this(false);
    }

    public ExcelWriter(boolean isXlsx) {
        this(ExcelUtil.createBook(isXlsx ? ".xlsx" : ".xls"), null);
    }

    public ExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public ExcelWriter(String destFilePath, String sheetName) {
        this(FileUtil.file(destFilePath), sheetName);
    }

    public ExcelWriter(File destFile) {
        this(destFile, null);
    }

    public ExcelWriter(File destFile, String sheetName) {
        this(ExcelUtil.createBook(destFile), sheetName);
        this.destFile = destFile;
    }

    public ExcelWriter(Workbook workbook, String sheetName) {
        this.workbook = workbook;
        this.sheet = ExcelUtil.getOrCreateSheet(workbook, sheetName);
        this.styleSet = new StyleSet(workbook);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells) {
        this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public CellStyle getHeadCellStyle() {
        return this.styleSet.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.styleSet.cellStyle;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    public ExcelWriter passRows(int rows) {
        this.currentRow.addAndGet(rows);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    public ExcelWriter setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public ExcelWriter setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int rowIndex = this.currentRow.get();
        Cell cell = this.sheet.createRow(rowIndex).createCell(0);
        if (null != this.styleSet.headCellStyle) {
            cell.setCellStyle(this.styleSet.headCellStyle);
            InternalExcelUtil.mergingCells(this.sheet, rowIndex, rowIndex, 0, lastColumn, this.styleSet.headCellStyle);
        }
        if (null != content) {
            InternalExcelUtil.setCellValue(cell, content, this.styleSet);
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int index = 0;
        for (Object object : data) {
            if (object instanceof Iterable) {
                this.writeRow((Iterable)object);
            } else if (object instanceof Map) {
                this.writeRows((Map)object, 0 == index);
            } else {
                if (!BeanUtil.isBean(object.getClass())) break;
                this.writeRows(BeanUtil.beanToMap(object), 0 == index);
            }
            ++index;
        }
        if (0 == index) {
            this.writeRow(data);
        }
        return this;
    }

    public <T> ExcelWriter write(Iterable<T> data, Comparator<String> comparator) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirstRow = true;
        for (T t : data) {
            Map<String, Object> map;
            if (t instanceof Map) {
                map = new TreeMap(comparator);
                map.putAll((Map)t);
            } else {
                map = BeanUtil.beanToMap(t, new TreeMap<String, Object>(comparator), false, false);
            }
            this.writeRows(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        InternalExcelUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet);
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        InternalExcelUtil.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet);
        return this;
    }

    public ExcelWriter writeRows(Map<?, ?> rowMap, boolean isWriteKeys) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        if (isWriteKeys) {
            this.writeHeadRow(this.aliasHeader(rowMap.keySet()));
        }
        this.writeRow(rowMap.values());
        return this;
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        Row row = InternalExcelUtil.getOrCreateRow(this.sheet, y);
        Cell cell = InternalExcelUtil.getOrCreateCell(row, x);
        InternalExcelUtil.setCellValue(cell, value, this.styleSet);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelWriter flush() throws IORuntimeException {
        BufferedOutputStream out = null;
        try {
            out = FileUtil.getOutputStream(this.destFile);
            this.flush(out);
        }
        finally {
            IoUtil.close(out);
        }
        return this;
    }

    public ExcelWriter flush(OutputStream out) throws IORuntimeException {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        try {
            this.workbook.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        IoUtil.close((Closeable)this.workbook);
        this.currentRow = null;
        this.styleSet = null;
        this.sheet = null;
        this.workbook = null;
        this.isClosed = true;
    }

    private Collection<?> aliasHeader(Collection<?> keys) {
        if (MapUtil.isEmpty(this.headerAlias)) {
            return keys;
        }
        ArrayList alias = new ArrayList();
        for (Object key : keys) {
            String aliasName = this.headerAlias.get(key);
            alias.add(null == aliasName ? key : aliasName);
        }
        return alias;
    }
}

