/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.convert.BasicType;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.JarClassLoader;
import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderUtil {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<String, Class<?>> primitiveTypeNameMap = new ConcurrentHashMap(32);
    private static SimpleCache<String, Class<?>> classCache = new SimpleCache();

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassLoaderUtil.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class<?> loadClass(String name) throws UtilException {
        return ClassLoaderUtil.loadClass(name, true);
    }

    public static Class<?> loadClass(String name, boolean isInitialized) throws UtilException {
        return ClassLoaderUtil.loadClass(name, null, isInitialized);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized) throws UtilException {
        Class<?> clazz;
        block11: {
            Assert.notNull(name, "Name must not be null", new Object[0]);
            clazz = ClassLoaderUtil.loadPrimitiveClass(name);
            if (clazz == null) {
                clazz = classCache.get(name);
            }
            if (clazz != null) {
                return clazz;
            }
            if (name.endsWith(ARRAY_SUFFIX)) {
                String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementClassName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
                String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
                String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                if (null == classLoader) {
                    classLoader = ClassLoaderUtil.getClassLoader();
                }
                try {
                    clazz = Class.forName(name, isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = ClassLoaderUtil.tryLoadInnerClass(name, classLoader, isInitialized);
                    if (null != clazz) break block11;
                    throw new UtilException(ex);
                }
            }
        }
        return classCache.put(name, clazz);
    }

    public static Class<?> loadPrimitiveClass(String name) {
        Class<?> result = null;
        if (StrUtil.isNotBlank(name) && (name = name.trim()).length() <= 8) {
            result = primitiveTypeNameMap.get(name);
        }
        return result;
    }

    public static JarClassLoader getJarClassLoader(File jarOrDir) {
        return JarClassLoader.load(jarOrDir);
    }

    public static Class<?> loadClass(File jarOrDir, String name) {
        try {
            return ClassLoaderUtil.getJarClassLoader(jarOrDir).loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
    }

    public static boolean isPresent(String className) {
        return ClassLoaderUtil.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassLoaderUtil.loadClass(className, classLoader, false);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static Class<?> tryLoadInnerClass(String name, ClassLoader classLoader, boolean isInitialized) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                return Class.forName(innerClassName, isInitialized, classLoader);
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ArrayList primitiveTypes = new ArrayList(32);
        primitiveTypes.addAll(BasicType.primitiveWrapperMap.keySet());
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
    }
}

