/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.page;

import cn.stylefeng.roses.core.context.RequestDataHolder;
import cn.stylefeng.roses.core.reqres.request.RequestData;
import cn.stylefeng.roses.core.util.HttpContext;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.model.page.PageQuery;
import cn.stylefeng.roses.kernel.model.util.ValidateUtil;
import com.baomidou.mybatisplus.plugins.Page;
import javax.servlet.http.HttpServletRequest;

public class PageFactory {
    private static final String ASC = "asc";
    private static final String PAGE_SIZE_PARAM_NAME = "pageSize";
    private static final String PAGE_NO_PARAM_NAME = "pageNo";
    private static final String SORT_PARAM_NAME = "sort";
    private static final String ORDER_BY_PARAM_NAME = "orderBy";

    public static <T> Page<T> defaultPage() {
        String pageNoString;
        int pageSize = 20;
        int pageNo = 1;
        HttpServletRequest request = HttpContext.getRequest();
        if (request == null) {
            return new Page(pageNo, pageSize);
        }
        String pageSizeString = PageFactory.getFieldValue(request, PAGE_SIZE_PARAM_NAME);
        if (ValidateUtil.isNotEmpty((Object)pageSizeString)) {
            pageSize = Integer.valueOf(pageSizeString);
        }
        if (ValidateUtil.isNotEmpty((Object)(pageNoString = PageFactory.getFieldValue(request, PAGE_NO_PARAM_NAME)))) {
            pageNo = Integer.valueOf(pageNoString);
        }
        String sort = PageFactory.getFieldValue(request, SORT_PARAM_NAME);
        String orderByField = PageFactory.getFieldValue(request, ORDER_BY_PARAM_NAME);
        if (ToolUtil.isEmpty((Object)sort)) {
            Page page = new Page(pageNo, pageSize);
            page.setOpenSort(false);
            return page;
        }
        Page page = new Page(pageNo, pageSize, orderByField);
        if (ASC.equalsIgnoreCase(sort)) {
            page.setAsc(true);
        } else {
            page.setAsc(false);
        }
        return page;
    }

    public static <T> Page<T> createPage(PageQuery pageQuery) {
        int pageSize = 20;
        int pageNo = 1;
        if (pageQuery != null && ValidateUtil.isNotEmpty((Object)pageQuery.getPageSize())) {
            pageSize = pageQuery.getPageSize();
        }
        if (pageQuery != null && ValidateUtil.isNotEmpty((Object)pageQuery.getPageNo())) {
            pageNo = pageQuery.getPageNo();
        }
        if (pageQuery == null) {
            Page page = new Page(pageNo, pageSize);
            page.setOpenSort(false);
            return page;
        }
        if (ToolUtil.isEmpty((Object)pageQuery.getSort())) {
            Page page = new Page(pageNo, pageSize);
            page.setOpenSort(false);
            return page;
        }
        Page page = new Page(pageNo, pageSize, pageQuery.getOrderByField());
        if (ASC.equalsIgnoreCase(pageQuery.getSort())) {
            page.setAsc(true);
        } else {
            page.setAsc(false);
        }
        return page;
    }

    private static String getFieldValue(HttpServletRequest request, String fieldName) {
        String parameter = request.getParameter(fieldName);
        if (parameter == null) {
            RequestData requestData = RequestDataHolder.get();
            if (requestData == null) {
                return null;
            }
            Object fieldValue = requestData.get(fieldName);
            if (fieldValue == null) {
                return null;
            }
            return fieldValue.toString();
        }
        return null;
    }
}

