/*
 * Decompiled with CFR 0.152.
 */
package com.aerse.mail;

import com.aerse.mail.FreemarkerMimeMessage;
import com.aerse.mail.IMailSender;
import com.aerse.mail.NamingThreadFactory;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class FreemarkerMailSender {
    private static final Logger LOG = Logger.getLogger(FreemarkerMailSender.class);
    private String templateClasspathPrefix;
    private IMailSender mailSender;
    private boolean enabled;
    private boolean useSeparateThread;
    private Configuration freemarkerConfig;
    private ExecutorService threadpool;

    public void start() {
        this.freemarkerConfig = new Configuration();
        this.freemarkerConfig.setDefaultEncoding("UTF-8");
        this.freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freemarkerConfig.setClassForTemplateLoading(FreemarkerMailSender.class, this.templateClasspathPrefix);
        this.freemarkerConfig.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.threadpool = this.useSeparateThread ? Executors.newFixedThreadPool(1, new NamingThreadFactory("aerse-email")) : null;
    }

    public void stop() {
        if (this.threadpool != null) {
            this.threadpool.shutdown();
        }
    }

    public void sendQuietly(FreemarkerMimeMessage message) {
        if (message == null) {
            return;
        }
        try {
            this.send(message);
        }
        catch (MessagingException e) {
            LOG.error((Object)("unable to send message: " + message.getTo() + " subject: " + message.getSubject()), (Throwable)e);
        }
    }

    public void send(final FreemarkerMimeMessage message) throws MessagingException {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (message.getTo() == null || message.getTo().isEmpty()) {
            throw new IllegalArgumentException("\"to\" should be specified");
        }
        if (this.threadpool != null) {
            this.threadpool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FreemarkerMailSender.this.implSend(message);
                    }
                    catch (MessagingException e) {
                        LOG.error((Object)("unable to send message: " + message.getTo() + " subject: " + message.getSubject()), (Throwable)e);
                    }
                }
            });
        } else {
            this.implSend(message);
        }
    }

    private void implSend(FreemarkerMimeMessage message) throws MessagingException {
        String text;
        Map<Object, Object> modelToUse = message.getModel() == null ? new HashMap<Object, Object>() : message.getModel();
        Calendar calendar = Calendar.getInstance();
        modelToUse.put("currentYear", String.valueOf(calendar.get(1)));
        modelToUse.put("email", message.getTo().get(0));
        try {
            Template fTemplate = this.freemarkerConfig.getTemplate(message.getTemplate());
            StringWriter w = new StringWriter();
            fTemplate.process(modelToUse, (Writer)w);
            text = w.toString();
        }
        catch (Exception e1) {
            throw new MessagingException("unable to prepare message", e1);
        }
        if (!this.enabled) {
            LOG.info((Object)("sending message. subject: " + message.getSubject() + " body: " + text));
            return;
        }
        MimeMessage mime = new MimeMessage((Session)null);
        mime.setSubject(message.getSubject(), "UTF-8");
        if (message.getBcc() != null) {
            for (String cur : message.getBcc()) {
                mime.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(cur));
            }
        }
        if (message.getCc() != null) {
            for (String cur : message.getCc()) {
                mime.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cur));
            }
        }
        for (String cur : message.getTo()) {
            mime.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(cur));
        }
        mime.setContent((Object)text, "text/html; charset=UTF-8");
        if (message.getReplyTo() != null) {
            mime.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(message.getReplyTo())});
        }
        this.mailSender.send((Message)mime);
    }

    public void setTemplateClasspathPrefix(String templateClasspathPrefix) {
        this.templateClasspathPrefix = templateClasspathPrefix;
    }

    public void setMailSender(IMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUseSeparateThread(boolean useSeparateThread) {
        this.useSeparateThread = useSeparateThread;
    }
}

