/*
 * Decompiled with CFR 0.152.
 */
package com.aerse.mail;

import com.aerse.mail.IMailSender;
import com.aerse.mail.Log4jPrintStream;
import com.aerse.mail.PasswordAuthenticator;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RelayMailSender
implements IMailSender {
    private static final Logger LOG = Logger.getLogger(RelayMailSender.class);
    private long connectionTimeoutMillis;
    private String fromEmail;
    private String fromName;
    private String host;
    private int port;
    private String username;
    private String password;
    private PasswordAuthenticator auth;
    private InternetAddress from;

    public void start() throws UnsupportedEncodingException {
        this.from = new InternetAddress(this.fromEmail, this.fromName, "UTF-8");
        this.auth = new PasswordAuthenticator(this.username, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message message) throws MessagingException {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtps");
        props.setProperty("mail.smtps.host", this.host);
        props.setProperty("mail.smtps.port", String.valueOf(this.port));
        props.setProperty("mail.smtps.user", this.username);
        props.setProperty("mail.smtps.starttls.enable", "true");
        props.setProperty("mail.smtps.ssl.trust", "*");
        props.setProperty("mail.smtps.ssl.enable", "true");
        props.setProperty("mail.smtps.requiresAuthentication", "true");
        props.setProperty("mail.smtps.isSecure", "true");
        props.setProperty("mail.smtps.auth", "true");
        String timeoutMillisStr = String.valueOf(this.connectionTimeoutMillis);
        props.setProperty("mail.smtps.timeout", timeoutMillisStr);
        props.setProperty("mail.smtps.connectiontimeout", timeoutMillisStr);
        Session session = Session.getInstance((Properties)props, (Authenticator)this.auth);
        if (LOG.isDebugEnabled()) {
            try {
                session.setDebugOut(new PrintStream((OutputStream)new Log4jPrintStream(LOG, (Priority)Level.DEBUG), false, "UTF-8"));
                session.setDebug(true);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        message.setFrom((Address)this.from);
        try (Transport t = null;){
            t = session.getTransport();
            t.connect(this.host, this.port, this.username, this.password);
            t.sendMessage(message, message.getAllRecipients());
        }
    }

    public void setConnectionTimeoutMillis(long connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

