/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.alibaba.middleware.tls.util;

import com.alibaba.ans.shaded.com.alibaba.middleware.tls.log.TlsLogger;
import com.alibaba.ans.shaded.com.alibaba.middleware.tls.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class FileProperties {
    private final Properties properties = new Properties();
    private final String filepath;

    public FileProperties(String filepath) {
        if (!new File(filepath).exists()) {
            TlsLogger.error("filepath not exits:" + filepath);
            throw new RuntimeException(new FileNotFoundException(filepath));
        }
        this.filepath = filepath;
        this.init();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getFilepath() {
        return this.filepath;
    }

    private void init() {
        InputStreamReader r = null;
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(new File(this.filepath)), "UTF-8");
            this.properties.load(r);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly(r);
                throw throwable;
            }
        }
        FileUtil.closeQuietly(r);
    }

    public String get(String k) {
        return (String)this.getProperties().get(k);
    }

    public String set(String k, String v) {
        return (String)this.getProperties().setProperty(k, v);
    }

    public String remove(String k) {
        return (String)this.getProperties().remove(k);
    }
}

