/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.core;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.backups.FailoverReactor;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.cache.DiskCache;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Balancer;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Domain;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.EventDispatcher;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.MotionFlow;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.OperationTask;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.PushRecver;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.TenantInfo;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.ipms.IPManager;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.VIPServerProxy;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.NetUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class HostReactor {
    public static final long DEFAULT_DELAY = 3000L;
    private static final long DEFAULT_WAIT_TIME = 3000L;
    public static long updateHoldInterval = 5000L;
    private static final Map<String, ScheduledFuture<?>> futureMap = new HashMap();
    private static Map<String, Domain> domMap = new ConcurrentHashMap<String, Domain>(DiskCache.read());
    private static PushRecver pushRecver = new PushRecver();
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "VIPSERVER-CLIENT-UPDATER");
            thread.setDaemon(true);
            return thread;
        }
    });
    private static ScheduledExecutorService registor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "VIPSERVER-CLIENTER-REGISTOR");
            thread.setDaemon(true);
            return thread;
        }
    });
    private static FailoverReactor failoverReactor = new FailoverReactor();

    public static Map<String, Domain> getDomMap() {
        return domMap;
    }

    public static synchronized ScheduledFuture<?> addTask(UpdateTask task) {
        return executor.schedule(task, 3000L, TimeUnit.MILLISECONDS);
    }

    public static synchronized ScheduledFuture<?> addTask(OperationTask task) {
        return registor.scheduleWithFixedDelay(task, 3000L, 3000L, TimeUnit.MILLISECONDS);
    }

    public static Set<String> getDomsSubscribed() {
        HashSet<String> result = new HashSet<String>();
        ArrayList<Domain> domains = new ArrayList<Domain>(HostReactor.getDomMap().values());
        for (Domain domain : domains) {
            result.add(domain.getName());
        }
        return result;
    }

    public static Domain processDomJSON(String json) {
        Domain domObj = JSON.parseObject(json, Domain.class);
        Domain oldDom = domMap.get(domObj.getKey());
        if (domObj.getHosts() == null || !domObj.validate()) {
            return oldDom;
        }
        if (oldDom != null) {
            String key;
            Host host;
            if (oldDom.getLastRefTime() > domObj.getLastRefTime()) {
                VIPClient.LOG.warn("out of date data received, old-t: " + oldDom.getLastRefTime() + ", new-t: " + domObj.getLastRefTime());
            }
            domMap.put(domObj.getKey(), domObj);
            HashMap<String, Host> oldHostMap = new HashMap<String, Host>();
            for (Host host2 : oldDom.getHosts()) {
                oldHostMap.put(host2.toInetAddr(), host2);
            }
            HashMap<String, Host> newHostMap = new HashMap<String, Host>();
            for (Host host3 : domObj.getHosts()) {
                newHostMap.put(host3.toInetAddr(), host3);
            }
            HashSet<Host> hashSet = new HashSet<Host>();
            HashSet<Host> newHosts = new HashSet<Host>();
            HashSet<Host> remvHosts = new HashSet<Host>();
            ArrayList newDomHosts = new ArrayList(newHostMap.entrySet());
            for (Map.Entry entry : newDomHosts) {
                host = (Host)entry.getValue();
                key = (String)entry.getKey();
                if (oldHostMap.containsKey(key) && !StringUtils.equals(host.toString(), ((Host)oldHostMap.get(key)).toString())) {
                    hashSet.add(host);
                    continue;
                }
                if (oldHostMap.containsKey(key)) continue;
                newHosts.add(host);
            }
            for (Map.Entry entry : oldHostMap.entrySet()) {
                host = (Host)entry.getValue();
                key = (String)entry.getKey();
                if (newHostMap.containsKey(key) || newHostMap.containsKey(key)) continue;
                remvHosts.add(host);
            }
            if (newHosts.size() > 0) {
                VIPClient.LOG.info("new ips(" + newHosts.size() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(newHosts));
            }
            if (remvHosts.size() > 0) {
                VIPClient.LOG.info("removed ips(" + remvHosts.size() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(remvHosts));
            }
            if (hashSet.size() > 0) {
                VIPClient.LOG.info("modified ips(" + hashSet.size() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(hashSet));
            }
            domObj.setJsonFromServer(json);
            if (newHosts.size() > 0 || remvHosts.size() > 0 || hashSet.size() > 0) {
                EventDispatcher.domChanged(domObj);
                DiskCache.write(domObj);
            }
        } else {
            VIPClient.LOG.info("new ips(" + domObj.ipCount() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(domObj.getHosts()));
            domMap.put(domObj.getKey(), domObj);
            EventDispatcher.domChanged(domObj);
            domObj.setJsonFromServer(json);
            DiskCache.write(domObj);
        }
        VIPClient.LOG.info("current ips:(" + domObj.ipCount() + ") dom: " + domObj.getName() + " -> " + JSON.toJSONString(domObj.getHosts()));
        return domObj;
    }

    private static Domain getDom0(String dom, String clusters, boolean allIPs) {
        return domMap.get(Domain.getKey(dom, clusters, "", allIPs));
    }

    private static Domain getDom0(String dom, String clusters, String env) {
        String key = Domain.getKey(dom, clusters, env, false);
        return domMap.get(key);
    }

    private static Domain getDom0(String dom, String clusters, String env, boolean allIPs) {
        String key = Domain.getKey(dom, clusters, env, allIPs);
        return domMap.get(key);
    }

    public static Domain getDom(String dom, String clusters) {
        return HostReactor.getDom(dom, clusters, "");
    }

    public static Domain getDom(String dom, String clusters, String env) {
        return HostReactor.getDom(dom, clusters, env, false);
    }

    public static Domain getDom(String dom, String clusters, String env, boolean allIPs) {
        return HostReactor.getDom(dom, clusters, env, allIPs, -1L);
    }

    public static Domain getDom(String dom, String clusters, long timeout) {
        String env = "";
        if (StringUtils.isNotEmpty(TenantInfo.tenantEnv)) {
            env = TenantInfo.tenantEnv;
        }
        return HostReactor.getDom(dom, clusters, env, false, timeout);
    }

    public static Domain getDom(String dom, String clusters, boolean allIPs) {
        String env = "";
        if (StringUtils.isNotEmpty(TenantInfo.tenantEnv)) {
            env = TenantInfo.tenantEnv;
        }
        return HostReactor.getDom(dom, clusters, env, allIPs, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Domain getDom(String dom, String clusters, String env, boolean allIPs, long timeout) {
        VIPClient.LOG.debug("failover-mode: " + failoverReactor.isFailoverSwitch());
        String key = Domain.getKey(dom, clusters, env, false);
        if (failoverReactor.isFailoverSwitch()) {
            return failoverReactor.getDom(key);
        }
        Domain domObj = HostReactor.getDom0(dom, clusters, env, allIPs);
        if (null == domObj) {
            domObj = new Domain(dom, clusters, env);
            if (allIPs) {
                domObj.setAllIPs(allIPs);
            }
            domMap.put(domObj.getKey(), domObj);
            if (allIPs) {
                HostReactor.updateDom4AllIPNow(dom, clusters, env);
            } else {
                List<Host> hosts = Balancer.RR.selectAllFromSpecifiedURL(domObj);
                if (!CollectionUtils.isEmpty(hosts)) {
                    domObj.setHostsFromSpecifiedURL(hosts);
                }
                HostReactor.updateDomNow(dom, clusters, env);
            }
        } else if (domObj.getHosts().isEmpty() && updateHoldInterval > 0L) {
            Domain domain = domObj;
            synchronized (domain) {
                try {
                    domObj.wait(updateHoldInterval);
                }
                catch (InterruptedException e) {
                    VIPClient.LOG.error("[getDom]", "dom:" + dom + ", clusters:" + clusters + ", allIPs:" + allIPs, e);
                }
            }
        }
        HostReactor.scheduleUpdateIfAbsent(dom, clusters, env, allIPs);
        return domMap.get(domObj.getKey());
    }

    public static void scheduleUpdateIfAbsent(String dom, String clusters, String env) {
        HostReactor.scheduleUpdateIfAbsent(dom, clusters, env, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleUpdateIfAbsent(String dom, String clusters, String env, boolean allIPs) {
        if (futureMap.get(Domain.getKey(dom, clusters, env, allIPs)) != null) {
            return;
        }
        Map<String, ScheduledFuture<?>> map = futureMap;
        synchronized (map) {
            if (futureMap.get(Domain.getKey(dom, clusters, env, allIPs)) != null) {
                return;
            }
            ScheduledFuture<?> future = HostReactor.addTask(new UpdateTask(dom, clusters, env, allIPs));
            futureMap.put(Domain.getKey(dom, clusters, env, allIPs), future);
        }
    }

    public static void updateDom4AllIPNow(String dom, String clusters, String env) {
        HostReactor.updateDom4AllIPNow(dom, clusters, env, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDom4AllIPNow(String dom, String clusters, String env, long timeout) {
        try {
            String result;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dom", dom);
            params.put("clusters", clusters);
            params.put("udpPort", String.valueOf(pushRecver.getUDPPort()));
            params.put("qps", String.valueOf(MotionFlow.view(dom)));
            Domain oldDom = HostReactor.getDom0(dom, clusters, env, true);
            if (oldDom != null) {
                params.put("checksum", oldDom.getChecksum());
            }
            if (StringUtils.isNotEmpty(result = VIPServerProxy.reqAPI("srvAllIP", params))) {
                Domain domain = HostReactor.processDomJSON(result);
                domain.setAllIPs(true);
            }
            Domain domain = oldDom;
            synchronized (domain) {
                oldDom.notifyAll();
            }
        }
        catch (Throwable e) {
            VIPClient.LOG.error("NA", "failed to update dom: " + dom, e);
        }
    }

    public static List<Host> updateDomNowWithOutCache(String dom, String clusters, String env) {
        Domain domain = null;
        try {
            String result;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dom", dom);
            params.put("clusters", clusters);
            params.put("udpPort", String.valueOf(pushRecver.getUDPPort()));
            params.put("qps", String.valueOf(MotionFlow.view(dom)));
            params.put("env", env);
            params.put("clientIP", NetUtils.localIP());
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : Balancer.unconsistentDomWithAddressServer) {
                stringBuilder.append(string).append(",");
            }
            Balancer.unconsistentDomWithAddressServer.clear();
            params.put("unconsistentDom", stringBuilder.toString());
            if (!StringUtils.isEmpty(env) && !env.contains(",")) {
                params.put("useEnvId", "true");
            }
            if (StringUtils.isNotEmpty(result = VIPServerProxy.reqAPI("srvIPXT", params))) {
                domain = JSON.parseObject(result, Domain.class);
            }
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to update dom: " + dom, e);
        }
        return domain == null ? new ArrayList() : domain.getHosts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDomNow(String dom, String clusters, String env) {
        Object params;
        Domain oldDom = HostReactor.getDom0(dom, clusters, env);
        try {
            String result;
            params = new HashMap<String, String>();
            params.put("dom", dom);
            params.put("clusters", clusters);
            params.put("udpPort", String.valueOf(pushRecver.getUDPPort()));
            params.put("qps", String.valueOf(MotionFlow.view(dom)));
            params.put("env", env);
            params.put("clientIP", NetUtils.localIP());
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : Balancer.unconsistentDomWithAddressServer) {
                stringBuilder.append(string).append(",");
            }
            Balancer.unconsistentDomWithAddressServer.clear();
            params.put("unconsistentDom", stringBuilder.toString());
            if (!StringUtils.isEmpty(env) && !env.contains(",")) {
                params.put((String)"useEnvId", (String)"true");
            }
            if (oldDom != null) {
                params.put((String)"checksum", (String)oldDom.getChecksum());
            }
            if (StringUtils.isNotEmpty(result = VIPServerProxy.reqAPI("srvIPXT", params))) {
                HostReactor.processDomJSON(result);
            }
        }
        catch (Throwable e) {
            VIPClient.LOG.error("NA", "failed to update dom: " + dom, e);
        }
        finally {
            if (oldDom != null) {
                params = oldDom;
                synchronized (params) {
                    oldDom.notifyAll();
                }
            }
        }
    }

    public static void refreshOnly(String dom, String clusters, String env, boolean allIPs) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dom", dom);
            params.put("clusters", clusters);
            params.put("udpPort", String.valueOf(pushRecver.getUDPPort()));
            params.put("unit", env);
            params.put("clientIP", NetUtils.localIP());
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : Balancer.unconsistentDomWithAddressServer) {
                stringBuilder.append(string).append(",");
            }
            Balancer.unconsistentDomWithAddressServer.clear();
            params.put("unconsistentDom", stringBuilder.toString());
            if (!env.contains(",")) {
                params.put("useEnvId", "true");
            }
            if (allIPs) {
                VIPServerProxy.reqAPI("srvAllIP", params);
            } else {
                VIPServerProxy.reqAPI("srvIPXT", params);
            }
        }
        catch (Throwable e) {
            VIPClient.LOG.error("NA", "failed to update dom: " + dom, e);
        }
    }

    public static class UpdateTask
    implements Runnable {
        long lastRefTime = Long.MAX_VALUE;
        private String clusters;
        private String dom;
        private String env;
        private boolean allIPs = false;

        public UpdateTask(String dom, String clusters, String env) {
            this.dom = dom;
            this.clusters = clusters;
            this.env = env;
        }

        public UpdateTask(String dom, String clusters, String env, boolean allIPs) {
            this.dom = dom;
            this.clusters = clusters;
            this.env = env;
            this.allIPs = allIPs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long delay = 3000L;
            try {
                List<Host> hosts;
                Domain domObj = (Domain)domMap.get(Domain.getKey(this.dom, this.clusters, this.env, this.allIPs));
                if (domObj == null) {
                    if (this.allIPs) {
                        HostReactor.updateDom4AllIPNow(this.dom, this.clusters, this.env);
                    } else {
                        HostReactor.updateDomNow(this.dom, this.clusters, this.env);
                        executor.schedule(this, 3000L, TimeUnit.MILLISECONDS);
                        domObj = (Domain)domMap.get(Domain.getKey(this.dom, this.clusters, this.env));
                        List<Host> hosts2 = Balancer.RR.selectAllFromSpecifiedURL(domObj);
                        if (!CollectionUtils.isEmpty(hosts2)) {
                            domObj.setHostsFromSpecifiedURL(hosts2);
                        }
                    }
                    return;
                }
                if ((domObj.getIsUseSpecifiedURL().booleanValue() || IPManager.isCompatibleMode()) && !CollectionUtils.isEmpty(hosts = Balancer.RR.selectAllFromSpecifiedURL(domObj))) {
                    domObj.setHostsFromSpecifiedURL(hosts);
                }
                if (domObj.getLastRefTime() <= this.lastRefTime) {
                    if (this.allIPs) {
                        HostReactor.updateDom4AllIPNow(this.dom, this.clusters, this.env);
                        domObj = (Domain)domMap.get(Domain.getKey(this.dom, this.clusters, this.env, true));
                    } else {
                        HostReactor.updateDomNow(this.dom, this.clusters, this.env);
                        domObj = (Domain)domMap.get(Domain.getKey(this.dom, this.clusters, this.env));
                    }
                } else {
                    HostReactor.refreshOnly(this.dom, this.clusters, this.env, this.allIPs);
                }
                delay = domObj.getCacheMillis();
                this.lastRefTime = domObj.getLastRefTime();
            }
            catch (Throwable e) {
                VIPClient.LOG.error("NA", "failed to update dom: " + this.dom, e);
            }
            finally {
                try {
                    executor.schedule(this, delay, TimeUnit.MILLISECONDS);
                }
                catch (Throwable e) {
                    VIPClient.LOG.error("NA", "failed to schedule update task for dom: " + this.dom, e);
                }
            }
        }
    }
}

