/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.core;

import com.alibaba.ans.shaded.com.taobao.middleware.logger.Level;
import com.alibaba.ans.shaded.com.taobao.middleware.logger.Logger;
import com.alibaba.ans.shaded.com.taobao.middleware.logger.LoggerFactory;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.beat.BeatInfo;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.beat.BeatReactor;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Balancer;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Domain;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.EventDispatcher;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.HostListener;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.HostReactor;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.IPListener;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.TenantInfo;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.ipms.NodeReactor;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.VIPServerProxy;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class VIPClient {
    public static Logger LOG = LoggerFactory.getLogger(VIPClient.class);
    private static String encoding = "GBK";
    private static String cacheDir;
    private static String logName;
    private static String jmenv;
    private static String vipserverDomain;
    private static String logLevel;
    private static String addressServerDomain;
    private static final AtomicBoolean logInited;
    public static final String APPENDER_NAME = "vslogger";
    public static final String VERSION = "VIPServer-Java-Client:v4.7.6";
    public static final Map<String, BeatInfo> dom2Beat;

    public static List<Host> getAllHosts(String dom) throws Exception {
        return VIPClient.getAllHosts(dom, "");
    }

    public static List<Host> getAllHostsWithTimeout(String dom, long timeout) throws Exception {
        return VIPClient.getAllHostsWithTimeout(dom, "", timeout);
    }

    public static List<Host> getAllHosts(String dom, String clusters) throws Exception {
        return VIPClient.getAllHostsWithTimeout(dom, clusters, -1L);
    }

    public static List<Host> getAllHostsWithTimeout(String dom, String clusters, long timeout) throws Exception {
        Domain domain = HostReactor.getDom(dom, clusters, "", true, timeout);
        if (domain == null || CollectionUtils.isEmpty(domain.getHosts())) {
            throw new IllegalStateException("no host to srv for dom: " + dom);
        }
        return domain.getHosts();
    }

    public static Host srvHost(String dom) throws Exception {
        return VIPClient.srvHostWithTimeout(dom, -1L);
    }

    public static Host srvHostWithTimeout(String dom, long timeout) throws Exception {
        return Balancer.RR.selectHost(HostReactor.getDom(dom, "", timeout));
    }

    public static Host srvHost(String dom, String clusters) throws Exception {
        return VIPClient.srvHostWithTimeout(dom, clusters, -1L);
    }

    public static Host srvHostWithTimeout(String dom, String clusters, long timeout) throws Exception {
        return Balancer.RR.selectHost(HostReactor.getDom(dom, clusters, timeout));
    }

    public static Host srvHost(String dom, long userId) throws Exception {
        return VIPClient.srvHostWithTimeout(dom, userId, -1L);
    }

    public static Host srvHostWithTimeout(String dom, long userId, long timeout) throws Exception {
        return Balancer.Unit.selectHost(HostReactor.getDom(dom, "", timeout), userId);
    }

    public static Host srvHost(String dom, String clusters, long userId) throws Exception {
        return VIPClient.srvHostWithTimeout(dom, clusters, userId, -1L);
    }

    public static Host srvHostWithTimeout(String dom, String clusters, long userId, long timeout) throws Exception {
        return Balancer.Unit.selectHost(HostReactor.getDom(dom, clusters, timeout), userId);
    }

    public static List<Host> srvHosts(String dom) throws Exception {
        return VIPClient.srvHostsWithTimeout(dom, -1L);
    }

    public static List<Host> srvHostsWithTimeout(String dom, long timeout) throws Exception {
        return Balancer.RR.selectAll(HostReactor.getDom(dom, "", timeout));
    }

    public static List<Host> srvHosts(String dom, String clusters) throws Exception {
        return VIPClient.srvHostsWithTimeout(dom, clusters, -1L);
    }

    public static List<Host> srvHostsWithTimeout(String dom, String clusters, long timeout) throws Exception {
        return Balancer.RR.selectAll(HostReactor.getDom(dom, clusters, timeout));
    }

    public static List<Host> getHosts(String dom) throws Exception {
        return Balancer.RR.nothing(HostReactor.getDom(dom, ""));
    }

    public static List<Host> getHostsWithTimeout(String dom, long timeout) throws Exception {
        return Balancer.RR.nothing(HostReactor.getDom(dom, "", timeout));
    }

    public static List<Host> getHosts(String dom, String clusters) throws Exception {
        return VIPClient.getHostsWithTimeout(dom, clusters, -1L);
    }

    public static List<Host> getHostsWithTimeout(String dom, String clusters, long timeout) throws Exception {
        return Balancer.RR.nothing(HostReactor.getDom(dom, clusters, timeout));
    }

    public static List<Host> getHosts(String dom, long userId) throws Exception {
        return VIPClient.getHostsWithTimeout(dom, userId, -1L);
    }

    public static List<Host> getHostsWithTimeout(String dom, long userId, long timeout) throws Exception {
        return Balancer.Unit.nothing(HostReactor.getDom(dom, "", timeout), userId);
    }

    public static List<Host> getHosts(String dom, String clusters, long userId) throws Exception {
        return VIPClient.getHostsWithTimeout(dom, clusters, userId, -1L);
    }

    public static List<Host> getHostsWithTimeout(String dom, String clusters, long userId, long timeout) throws Exception {
        return Balancer.Unit.nothing(HostReactor.getDom(dom, clusters, timeout), userId);
    }

    public static void addIP4Dom(String dom, String token, String ipList) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dom", dom);
        params.put("ipList", ipList);
        params.put("token", token);
        VIPServerProxy.reqAPI("addIP4Dom", params);
    }

    public static void setWeight4AllDoms(String ipList, String token) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ipList", ipList);
        params.put("token", token);
        VIPServerProxy.reqAPI("setWeight4AllIPs", params);
    }

    public static void remvIP4Dom(String dom, String token, String ipList) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dom", dom);
        params.put("ipList", ipList);
        params.put("token", token);
        VIPServerProxy.reqAPI("remvIP4Dom", params);
    }

    public static void listen(String dom, HostListener listener) {
        EventDispatcher.addListener(dom, "", listener);
    }

    public static void listen(String dom, IPListener listener) {
        EventDispatcher.addListener(dom, "", listener);
    }

    public static void listen(String dom, String clusters, HostListener listener) {
        EventDispatcher.addListener(dom, clusters, listener);
    }

    public static void listen(String dom, String clusters, IPListener listener) {
        EventDispatcher.addListener(dom, clusters, listener);
    }

    public static void unlisten(String dom, HostListener listener) {
        EventDispatcher.removeListener(dom, "", listener);
    }

    public static void unlisten(String dom, IPListener listener) {
        EventDispatcher.removeListener(dom, "", listener);
    }

    public static String srvIP(String dom) throws Exception {
        Host host = VIPClient.srvHost(dom);
        String ip = host.getIp() + ":" + host.getPort();
        return ip;
    }

    public static String srvIP(String dom, String clusters) throws Exception {
        Host host = VIPClient.srvHost(dom, clusters);
        String ip = host.getIp() + ":" + host.getPort();
        return ip;
    }

    public static List<String> srvIPs(String dom) throws Exception {
        List<Host> hosts = VIPClient.srvHosts(dom);
        ArrayList<String> ips = new ArrayList<String>();
        for (Host host : hosts) {
            String ip = host.getIp() + ":" + host.getPort();
            ips.add(ip);
        }
        return ips;
    }

    public static List<String> srvIPs(String dom, String clusters) throws Exception {
        List<Host> hosts = VIPClient.srvHosts(dom, clusters);
        ArrayList<String> ips = new ArrayList<String>();
        for (Host host : hosts) {
            String ip = host.getIp() + ":" + host.getPort();
            ips.add(ip);
        }
        return ips;
    }

    public static void regDom(String dom, String ip, int port) throws Exception {
        VIPClient.regDom(dom, ip, port, 1.0f, "DEFAULT", new ArrayList<NodeReactor.Tag>());
    }

    public static void regDom(String dom, String ip, int port, float weight, String cluster) throws Exception {
        VIPClient.regDom(dom, ip, port, weight, cluster, new ArrayList<NodeReactor.Tag>());
    }

    public static void regDom(String dom, String ip, int port, float weight, String cluster, Map<String, Object> metadata) throws Exception {
        BeatInfo beatInfo = new BeatInfo();
        beatInfo.setDom(dom);
        beatInfo.setIp(ip);
        beatInfo.setAk(TenantInfo.tenantAk);
        beatInfo.setPort(port);
        beatInfo.setCluster(cluster);
        beatInfo.setTenant(TenantInfo.tenantId);
        dom2Beat.put(dom, beatInfo);
        VIPServerProxy.regDom(dom, ip, port, weight, cluster, metadata);
    }

    public static void regDom(String dom, String ip, int port, float weight, String cluster, List<NodeReactor.Tag> tags) throws Exception {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (NodeReactor.Tag tag : tags) {
            metadata.put(tag.getName(), tag.getValue());
        }
        VIPClient.regDom(dom, ip, port, weight, cluster, metadata);
    }

    public static void deRegDom(String doms, String ip, int port, String cluster) throws Exception {
        VIPServerProxy.deRegDom(doms, ip, port, cluster);
    }

    public static Map<String, List<String>> getSameSiteServers(String ip) {
        return VIPServerProxy.getSameSiteServers(ip);
    }

    public static Set<String> getPublishes() {
        return dom2Beat.keySet();
    }

    public static Set<String> getDomsSubscribed() {
        return HostReactor.getDomsSubscribed();
    }

    public static void setListenerExecutor(ExecutorService executor) {
        EventDispatcher.setExecutor(executor);
    }

    public static String getEncoding() {
        return encoding;
    }

    public static void setEncoding(String encoding) {
        VIPClient.encoding = encoding;
    }

    public static String getCacheDir() {
        return cacheDir;
    }

    public static String getLogName() {
        return logName;
    }

    public static String getJmenv() {
        return jmenv;
    }

    public static String getVipserverDomain() {
        return vipserverDomain;
    }

    public static void setVipserverDomain(String vipserverDomain) {
        VIPClient.vipserverDomain = vipserverDomain;
    }

    public static String getAddressServerDomain() {
        return addressServerDomain;
    }

    public static void setAddressServerDomain(String addressServerDomain) {
        VIPClient.addressServerDomain = addressServerDomain;
    }

    public static void main(String[] args) throws Exception {
        List<Host> hosts = VIPClient.getAllHosts("dungu.test.14", "DEFAULT");
        System.out.println(hosts);
    }

    static {
        logInited = new AtomicBoolean(false);
        dom2Beat = new ConcurrentHashMap<String, BeatInfo>();
        String logPath = System.getProperty("user.home") + File.separator + "vipsrv-logs" + File.separator + "vipclient.log";
        String parentName = new File(logPath).getParent();
        if (parentName == null) {
            throw new IllegalArgumentException("illegal logPath: " + logPath);
        }
        File parentDir = new File(parentName);
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IllegalArgumentException("unable to create parent dirs in logPath: " + logPath);
        }
        logName = System.getProperty("com.alibaba.vipserver.log.filename");
        if (StringUtils.isEmpty(logName)) {
            logName = "vipclient.log";
        }
        if (StringUtils.isEmpty(cacheDir = System.getProperty("com.alibaba.vipserver.cache.dir"))) {
            cacheDir = System.getProperty("user.home") + "/vipsrv-cache";
        }
        if (StringUtils.isNotEmpty(jmenv = System.getProperty("address.server.domain"))) {
            jmenv = jmenv + ":" + System.getProperty("address.server.port", "8080");
        }
        if (StringUtils.isNotEmpty(System.getProperty("com.alibaba.vipserver.jmenv"))) {
            jmenv = System.getProperty("com.alibaba.vipserver.jmenv");
        }
        if (StringUtils.isEmpty(jmenv)) {
            jmenv = "jmenv.tbsite.net:8080";
        }
        if (StringUtils.isEmpty(addressServerDomain = System.getProperty("com.alibaba.vipserver.address.domain"))) {
            addressServerDomain = "address-server.vipserver.alibaba-inc.com";
        }
        if (StringUtils.isEmpty(vipserverDomain = System.getProperty("com.alibaba.vipserver.domain"))) {
            vipserverDomain = "vipserver.all.hosts.alibaba-inc.com";
        }
        if (StringUtils.isEmpty(logLevel = System.getProperty("com.alibaba.vipserver.log.level")) || Level.codeOf(logLevel) == Level.OFF) {
            logLevel = "INFO";
        }
        try {
            HostReactor.updateHoldInterval = Long.parseLong(System.getProperty("com.alibaba.vipserver.update.hold.interval", "5000"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logInited.compareAndSet(false, true)) {
            LOG.activateAppenderWithSizeRolling("vipsrv-logs", "vipclient.log", encoding, "500MB", 5);
            LOG.setLevel(Level.codeOf(logLevel));
            LOG.setAdditivity(false);
        }
        if (StringUtils.isNotEmpty(TenantInfo.tenantId = System.getProperty("com.alibaba.vipserver.tenant.id"))) {
            TenantInfo.tenantApp = System.getProperty("com.alibaba.vipserver.tenant.app");
            TenantInfo.tenantEnv = System.getProperty("com.alibaba.vipserver.tenant.env");
            TenantInfo.tenantAk = System.getProperty("com.alibaba.vipserver.tenant.ak");
            TenantInfo.tenantSK = System.getProperty("com.alibaba.vipserver.tenant.sk");
        }
        BeatReactor.init();
        LOG.info("vipserver-client initialized, jmenv: " + jmenv + "; cache-dir: " + cacheDir + "; version: " + VERSION);
        LOG.info("enable tls: " + Boolean.parseBoolean(System.getProperty("tls.enable", "false")));
    }
}

