/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.ipms;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.alibaba.fastjson.JSONArray;
import com.alibaba.ans.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.ans.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.ans.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.ans.shaded.com.google.common.cache.CacheBuilder;
import com.alibaba.ans.shaded.com.google.common.cache.CacheLoader;
import com.alibaba.ans.shaded.com.google.common.cache.LoadingCache;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.cache.ConcurrentDiskUtil;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.cache.DiskCache;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.HostListener;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.ipms.NodeListener;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.ipms.SwitchListener;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.HttpClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.net.VIPServerProxy;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.IOUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.NetUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NodeReactor {
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("VIPSERVER-CLIENT-NODE-UPDATER");
            t.setDaemon(true);
            return t;
        }
    });
    private static ScheduledExecutorService dispatcher = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("VIPSERVER-CLIENT-NODE-EVENT-DISPATCHER");
            t.setDaemon(true);
            return t;
        }
    });
    private static boolean enableAutoUpdate = Boolean.valueOf(System.getProperty("com.alibaba.ans.shaded.com.taobao.vipserver.node.autoupdate", "true"));
    private static BlockingQueue<String> QUEUE = new LinkedBlockingDeque<String>(0x100000);
    private static Map<String, String> ipMap = new ConcurrentHashMap<String, String>();
    private static Set<String> allInterestsIPs = Collections.synchronizedSet(new HashSet());
    private static ConcurrentMap<HostListener, List<String>> observers = new ConcurrentHashMap<HostListener, List<String>>();
    private static Map<String, VIPServerProxy.Node> nodeCache = new ConcurrentHashMap<String, VIPServerProxy.Node>();
    private static HostCache hostsMap = new HostCache();
    private static ConcurrentMap<NodeListener, List<String>> listeners = new ConcurrentHashMap<NodeListener, List<String>>();
    private static Map<String, List<SwitchListener>> switchListeners = new ConcurrentHashMap<String, List<SwitchListener>>();
    private static ConcurrentMap<String, Boolean> changedIPs = new ConcurrentHashMap<String, Boolean>();
    private static final String PROPERTIES_FILE_PATH = System.getProperty("user.home") + File.separator + "vipsrv-cache" + File.separator + "vipclient.properties";
    private static final String HOSTS_CACHE_FILE = System.getProperty("user.home") + File.separator + "vipsrv-cache" + File.separator + "00-00---000-ALL_HOSTS-000---00-00";
    private static final String ENV_CACHE_FILE = System.getProperty("user.home") + File.separator + "vipsrv-cache" + File.separator + "00-00---000-ENV_CONFIGS-000---00-00";
    private static long timestamp = 0L;
    private static long cacheMillis = TimeUnit.SECONDS.toMillis(30L);
    public static boolean useAddressServer = false;
    private static long switchCacheMillis = TimeUnit.SECONDS.toMillis(30L);
    private static long envCacheMillis = TimeUnit.SECONDS.toMillis(60L);
    public static ConcurrentMap<String, List<Tag>> envMap = new ConcurrentHashMap<String, List<Tag>>();
    private static boolean compatibleMode = true;
    private static Map<String, Future> envUpdaterMap = new ConcurrentHashMap<String, Future>();
    private static List<String> diamondUnitList = new CopyOnWriteArrayList<String>();
    private static String envFromAddressServer = "";

    public static void cleanCache() {
        hostsMap = new HostCache();
        VIPClient.LOG.info("NA", "armory cache is cleaned up, size: " + hostsMap.asMap().size());
    }

    public static void refreshCache(String ip) {
        hostsMap.refreshCache(ip);
        VIPClient.LOG.info("NA", "armory cache of " + ip + " is cleaned up, size: " + hostsMap.asMap().size());
    }

    public static boolean isCompatibleMode() {
        return compatibleMode;
    }

    public static void setCompatibleMode(boolean compatibleMode) {
        NodeReactor.compatibleMode = compatibleMode;
    }

    private static void loadAddressServerConfig() {
        try {
            String config;
            IOUtils.makeSureParentDirExists(VIPClient.getCacheDir());
            IOUtils.createFileIfNessary(PROPERTIES_FILE_PATH);
            File file = new File(PROPERTIES_FILE_PATH);
            if (!file.exists()) {
                return;
            }
            String content = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
            List<Object> properties = new ArrayList();
            if (!StringUtils.isEmpty(content)) {
                properties = Arrays.asList(content.split(DiskCache.getLineSeperator()));
            }
            if (properties.size() >= 1 && (config = (String)properties.get(0)).startsWith("useAddressServer:")) {
                NodeReactor.setUseAddressServer(Boolean.parseBoolean(config.substring("useAddressServer:".length())));
            }
            if (properties.size() >= 2 && (config = (String)properties.get(1)).startsWith("compatibleMode:")) {
                NodeReactor.setCompatibleMode(Boolean.parseBoolean(config.substring("compatibleMode:".length())));
            }
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to load address server config.", e);
        }
    }

    private static void writeAddressServerConfig() {
        try {
            IOUtils.makeSureParentDirExists(VIPClient.getCacheDir());
            IOUtils.createFileIfNessary(PROPERTIES_FILE_PATH);
            File file = new File(PROPERTIES_FILE_PATH);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("useAddressServer:").append(useAddressServer).append(DiskCache.getLineSeperator()).append("compatibleMode:" + compatibleMode);
            ConcurrentDiskUtil.writeFileContent(file, stringBuilder.toString(), Charset.defaultCharset().toString());
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to write address server config.", e);
        }
    }

    private static void writeAllHosts2Disk() {
        try {
            IOUtils.makeSureParentDirExists(VIPClient.getCacheDir());
            IOUtils.createFileIfNessary(HOSTS_CACHE_FILE);
            File file = new File(HOSTS_CACHE_FILE);
            StringBuilder stringBuilder = new StringBuilder();
            Map<String, Host> stringHostMap = hostsMap.asMap();
            for (Host host : stringHostMap.values()) {
                stringBuilder.append(host.toString());
                stringBuilder.append(DiskCache.getLineSeperator());
            }
            ConcurrentDiskUtil.writeFileContent(file, stringBuilder.toString(), Charset.defaultCharset().toString());
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to write hosts to disk.", e);
        }
    }

    protected static void listenAddressServerSwitch(SwitchListener switchListener) {
        List<SwitchListener> switchListenerList = switchListeners.get("useAddressServer");
        if (CollectionUtils.isEmpty(switchListenerList)) {
            switchListenerList = new CopyOnWriteArrayList<SwitchListener>();
            switchListeners.put("useAddressServer", switchListenerList);
        }
        switchListenerList.add(switchListener);
        switchListener.onChanged(NodeReactor.isUseAddressServer());
    }

    protected static void removeAddressServerSwitch(SwitchListener switchListener) {
        List<SwitchListener> switchListenerList = switchListeners.get("useAddressServer");
        for (SwitchListener listener : switchListenerList) {
            if (listener != switchListener) continue;
            switchListenerList.remove(listener);
        }
    }

    private static void loadHostsFromDisk() {
        try {
            IOUtils.makeSureParentDirExists(VIPClient.getCacheDir());
            IOUtils.createFileIfNessary(HOSTS_CACHE_FILE);
            File file = new File(HOSTS_CACHE_FILE);
            String content = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
            List<Object> hostStrings = new ArrayList();
            if (!StringUtils.isEmpty(content)) {
                hostStrings = Arrays.asList(content.split(DiskCache.getLineSeperator()));
            }
            for (String hostString : hostStrings) {
                Host host = JSON.parseObject(hostString, Host.class);
                if (host == null || StringUtils.isEmpty(host.getIp())) continue;
                hostsMap.put(host.getIp(), host);
            }
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to write hosts to disk.", e);
        }
    }

    public static void interests(NodeListener listener, List<String> ips) {
        CopyOnWriteArrayList<String> copyOnWriteArrayList = new CopyOnWriteArrayList<String>(ips);
        listeners.put(listener, copyOnWriteArrayList);
        for (String ip : ips) {
            if (allInterestsIPs.contains(ip)) continue;
            allInterestsIPs.add(ip);
        }
        listener.onChanged(ips);
    }

    public static void removeNodeListener(NodeListener listener) {
        for (Map.Entry entry : listeners.entrySet()) {
            if (entry.getKey() != listener) continue;
            listeners.remove(listener);
            List ips = (List)entry.getValue();
            for (String ip : ips) {
                allInterestsIPs.remove(ip);
            }
        }
    }

    private static void onIPChanges() {
        for (Map.Entry entry : listeners.entrySet()) {
            List ips = (List)entry.getValue();
            boolean isChanged = false;
            ArrayList<String> hosts = new ArrayList<String>();
            for (String ip : ips) {
                if (!changedIPs.containsKey(ip)) continue;
                hosts.add(ip);
                if (isChanged) continue;
                isChanged = (Boolean)changedIPs.get(ip);
            }
            if (!isChanged || ((NodeListener)entry.getKey()).onChanged(hosts)) continue;
            VIPClient.LOG.error("NA", "failed to notify upper layer changed ips.");
        }
        for (Map.Entry entry : changedIPs.entrySet()) {
            changedIPs.put((String)entry.getKey(), false);
        }
    }

    protected static String getUnitByIP(String ip) {
        if (!ipMap.containsKey(ip)) {
            allInterestsIPs.add(ip);
            ipMap.put(ip, ip);
        }
        Host host = null;
        host = hostsMap.get(ip);
        if (host == null) {
            NodeReactor.updateNodeNow(ip, false);
            host = hostsMap.get(ip);
        }
        if (host == null) {
            VIPClient.LOG.error("NA", "can not find unit for " + ip);
            return null;
        }
        return host.getUnit();
    }

    protected static String getSiteByIP(String ip) {
        if (!ipMap.containsKey(ip)) {
            allInterestsIPs.add(ip);
            ipMap.put(ip, ip);
        }
        Host node = null;
        node = hostsMap.get(ip);
        if (node == null) {
            NodeReactor.updateNodeNow(ip, false);
            node = hostsMap.get(ip);
        }
        if (node == null) {
            VIPClient.LOG.error("NA", "can not find site for " + ip);
            return "unknown";
        }
        return node.getSite();
    }

    static Host getHostByIpSynchronously(String ip) {
        NodeReactor.updateNodeNow(ip, false);
        Host node = hostsMap.get(ip);
        if (node == null) {
            VIPClient.LOG.error("NA", "ip not found in armory: " + ip);
        }
        return node;
    }

    static List<Host> getHostsByIPs(List<String> ips) {
        ArrayList<Host> result = new ArrayList<Host>();
        for (String ip : ips) {
            Host node;
            if (!ipMap.containsKey(ip)) {
                allInterestsIPs.add(ip);
                ipMap.put(ip, ip);
            }
            if ((node = hostsMap.get(ip)) == null) {
                NodeReactor.updateNodeNow(ip, false);
                node = hostsMap.get(ip);
            }
            if (node == null) {
                VIPClient.LOG.error("NA", "ip not found in armory: " + ip);
            }
            result.add(node);
        }
        return result;
    }

    protected static synchronized boolean isUseAddressServer() {
        return useAddressServer;
    }

    protected static synchronized void setUseAddressServer(boolean enable) {
        useAddressServer = enable;
    }

    private static Host getNode(String ip) {
        String nodeJson;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ips", ip);
        params.put("timestamp", String.valueOf(timestamp));
        params.put("clientIP", NetUtils.localIP());
        try {
            nodeJson = VIPServerProxy.reqAPI("queryNodes", params);
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to update node: " + ip, e);
            nodeJson = "";
        }
        if (StringUtils.isEmpty(nodeJson)) {
            return null;
        }
        JSONObject jsonObject = JSON.parseObject(nodeJson);
        timestamp = jsonObject.getLong("timestamp");
        cacheMillis = jsonObject.getLong("armoryCacheMillis");
        JSONArray nodes = jsonObject.getJSONArray("nodes");
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        JSONObject node = nodes.getJSONObject(0);
        String unit = node.getString("unit");
        String nodeIP = node.getString("ip");
        String site = node.getString("site");
        String appUseType = node.getString("appUseType");
        String nodeGroup = node.getString("nodeGroup");
        String app = node.getString("appName");
        Host host = new Host();
        changedIPs.put(nodeIP, true);
        host.setIp(nodeIP);
        if (!StringUtils.isEmpty(unit)) {
            host.setUnit(unit);
        }
        if (!StringUtils.isEmpty(site)) {
            host.setSite(site);
        }
        if (!StringUtils.isEmpty(nodeIP)) {
            host.setIp(nodeIP);
        }
        if (!StringUtils.isEmpty(nodeGroup)) {
            host.setNodeGroup(nodeGroup);
        }
        if (!StringUtils.isEmpty(appUseType)) {
            host.setAppUseType(appUseType);
        }
        if (!StringUtils.isEmpty(app)) {
            host.setAppName(app);
        }
        return host;
    }

    private static boolean updateNodeNow(String ip, boolean appName) {
        boolean sucessful = true;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ips", ip);
        params.put("timestamp", String.valueOf(timestamp));
        params.put("clientIP", NetUtils.localIP());
        Map<String, Host> stringHostMap = hostsMap.asMap();
        try {
            String nodeJson = !appName ? VIPServerProxy.reqAPI("queryNodes", params) : VIPServerProxy.reqAPI("queryNodesByAppName", params);
            JSONObject jsonObject = JSON.parseObject(nodeJson);
            timestamp = jsonObject.getLong("timestamp");
            cacheMillis = jsonObject.getLong("armoryCacheMillis");
            Boolean enableAddressServer = jsonObject.getBoolean("useAddressServer");
            if (enableAddressServer != null) {
                if (NodeReactor.isUseAddressServer() != enableAddressServer) {
                    VIPClient.LOG.info("switch is changed, switch: useAddressServer, " + NodeReactor.isUseAddressServer() + " --> " + enableAddressServer);
                    NodeReactor.setUseAddressServer(enableAddressServer);
                    NotifyEvent event = NotifyEvent.SITE_CHANGE;
                    dispatcher.submit(new NotifyTask(event));
                }
                NodeReactor.writeAddressServerConfig();
            }
            JSONArray nodes = jsonObject.getJSONArray("nodes");
            for (int i = 0; i < nodes.size(); ++i) {
                JSONObject node = nodes.getJSONObject(i);
                String unit = node.getString("unit");
                String nodeIP = node.getString("ip");
                String site = node.getString("site");
                String appUseType = node.getString("appUseType");
                String nodeGroup = node.getString("nodeGroup");
                String app = node.getString("appName");
                Host host = null;
                if (!StringUtils.isEmpty(nodeIP)) {
                    host = stringHostMap.get(nodeIP);
                }
                if (!(StringUtils.isEmpty(unit) || host == null || StringUtils.equals(unit, stringHostMap.get(nodeIP).getUnit()) && StringUtils.equals(site, stringHostMap.get(nodeIP).getSite()))) {
                    VIPClient.LOG.info("unit or site of ip: " + nodeIP + " is changed, " + stringHostMap.get(nodeIP).getUnit() + " --> " + unit + " " + stringHostMap.get(nodeIP).getSite() + " --> " + site);
                    changedIPs.put(nodeIP, true);
                }
                if (host == null) {
                    host = new Host();
                    VIPClient.LOG.info("unit of ip: " + nodeIP + " is changed, null  --> " + unit);
                    changedIPs.put(nodeIP, true);
                }
                if (!StringUtils.isEmpty(unit)) {
                    host.setUnit(unit);
                }
                if (!StringUtils.isEmpty(site)) {
                    host.setSite(site);
                }
                if (!StringUtils.isEmpty(nodeIP)) {
                    host.setIp(nodeIP);
                }
                if (!StringUtils.isEmpty(appUseType)) {
                    host.setAppUseType(appUseType);
                }
                if (!StringUtils.isEmpty(nodeGroup)) {
                    host.setNodeGroup(nodeGroup);
                }
                if (!StringUtils.isEmpty(app)) {
                    host.setAppName(app);
                }
                if (StringUtils.isEmpty(host.getIp())) continue;
                hostsMap.put(host.getIp(), host);
            }
            return true;
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "error while updating node: " + ip, e);
            return false;
        }
    }

    private static void asyncUpdateNode() {
        try {
            new NodeUpdater(allInterestsIPs).run();
            executor.schedule(new Runnable(){

                @Override
                public void run() {
                    NodeReactor.asyncUpdateNode();
                }
            }, cacheMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to update interests node from server ", e);
        }
    }

    public static void setExecutor(ScheduledExecutorService executor) {
        dispatcher = executor;
    }

    private static void processSwitchJSON(String content) {
        if (StringUtils.isEmpty(content)) {
            VIPClient.LOG.error("NA", "Swith json string is empty.");
            return;
        }
        JSONObject jsonObject = JSON.parseObject(content);
        boolean addressServerSwitch = jsonObject.getBoolean("useAddressServer");
        boolean compatibleModeSwitch = jsonObject.getBoolean("compatibleMode");
        switchCacheMillis = jsonObject.getLong("switchCacheMillis");
        if (addressServerSwitch != NodeReactor.isUseAddressServer()) {
            VIPClient.LOG.info("switch is changed, switch: useAddressServer, " + NodeReactor.isUseAddressServer() + " --> " + addressServerSwitch);
            NodeReactor.setUseAddressServer(addressServerSwitch);
            NotifyEvent event = NotifyEvent.SWITCH_CHEANGE;
            dispatcher.submit(new NotifyTask(event));
        }
        if (compatibleModeSwitch != NodeReactor.isCompatibleMode()) {
            VIPClient.LOG.info("switch is changed, switch: useAddressServer, " + NodeReactor.isCompatibleMode() + " --> " + compatibleModeSwitch);
            NodeReactor.setCompatibleMode(compatibleModeSwitch);
        }
        NodeReactor.writeAddressServerConfig();
    }

    private static void loadEnvConfig() {
        try {
            IOUtils.makeSureParentDirExists(VIPClient.getCacheDir());
            IOUtils.createFileIfNessary(ENV_CACHE_FILE);
            File file = new File(ENV_CACHE_FILE);
            if (!file.exists()) {
                return;
            }
            String content = ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString());
            List<Object> properties = new ArrayList();
            if (!StringUtils.isEmpty(content)) {
                properties = Arrays.asList(content.split(DiskCache.getLineSeperator()));
            }
            if (properties.size() >= 1) {
                String config = (String)properties.get(0);
                if (StringUtils.isEmpty(config)) {
                    return;
                }
                ConcurrentMap<String, List<Tag>> envs = JSON.parseObject(config, new TypeReference<ConcurrentMap<String, List<Tag>>>(){}, new Feature[0]);
                if (envs != null) {
                    envMap = envs;
                }
            }
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to load env config.", e);
        }
    }

    private static void writeEnvConfig() {
        try {
            IOUtils.makeSureParentDirExists(VIPClient.getCacheDir());
            IOUtils.createFileIfNessary(ENV_CACHE_FILE);
            File file = new File(ENV_CACHE_FILE);
            ConcurrentDiskUtil.writeFileContent(file, JSON.toJSONString(envMap), Charset.defaultCharset().toString());
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "failed to write env config.", e);
        }
    }

    private static void processEnvJSON(String content, String ip) {
        if (StringUtils.isEmpty(content)) {
            VIPClient.LOG.error("NA", "Env json string is empty.");
            return;
        }
        VIPClient.LOG.info("processEnvJson, content: " + content);
        JSONObject jsonObject = JSON.parseObject(content);
        String env = jsonObject.getString("env");
        Tag envTag = JSON.parseObject(env, Tag.class);
        List<Tag> envList = JSON.parseObject(jsonObject.getString("envs"), new TypeReference<List<Tag>>(){}, new Feature[0]);
        envCacheMillis = jsonObject.getLong("envCacheMillis");
        String envGroup = jsonObject.getString("envGroup");
        Tag envGroupTag = new Tag();
        envGroupTag.setName("envGroupId");
        envGroupTag.setValue(envGroup);
        envGroupTag.setType("envGroup");
        envMap.put("env@@" + ip, Arrays.asList(envTag));
        envMap.put("envList@@" + ip, envList);
        envMap.put("envGroup@@" + ip, Arrays.asList(envGroupTag));
        NodeReactor.writeEnvConfig();
    }

    private static void onSwitchChange() {
        List<SwitchListener> switchListenerList = switchListeners.get("useAddressServer");
        if (switchListenerList == null) {
            return;
        }
        for (SwitchListener listener : switchListenerList) {
            if (listener.onChanged(NodeReactor.isUseAddressServer())) continue;
            VIPClient.LOG.error("NA", "failed to notify app when useAddressServer switch is changed. ");
        }
    }

    public static void getEnvListFromAddressServer() {
        block4: {
            List<Object> unitNameList = new ArrayList();
            try {
                HttpClient.HttpResult httpResult = HttpClient.httpGet("http://" + VIPClient.getJmenv() + "/diamond-server/unit-list?nofix=1", null, null, "GBK");
                if (200 == httpResult.code) {
                    unitNameList = IOUtils.readLines(new StringReader(httpResult.content));
                    if (unitNameList.size() > 0) {
                        diamondUnitList = unitNameList;
                    }
                    break block4;
                }
                throw new IOException("http code " + httpResult.code + ", msg: " + httpResult.content);
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "failed to get unit list from address server", e);
            }
        }
    }

    public static void getEnvFromAddressServer() {
        block4: {
            List<Object> unitNameList = new ArrayList();
            try {
                HttpClient.HttpResult httpResult = HttpClient.httpGet("http://" + VIPClient.getJmenv() + "/env", null, null, "GBK");
                if (200 == httpResult.code) {
                    unitNameList = IOUtils.readLines(new StringReader(httpResult.content));
                    if (unitNameList.size() > 0) {
                        envFromAddressServer = (String)unitNameList.get(0);
                    }
                    break block4;
                }
                throw new IOException("http code " + httpResult.code + ", msg: " + httpResult.content);
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "failed to get unit list from address server", e);
            }
        }
    }

    static {
        NodeReactor.loadAddressServerConfig();
        NodeReactor.loadHostsFromDisk();
        NodeReactor.loadEnvConfig();
        executor.schedule(new Runnable(){

            @Override
            public void run() {
                NodeReactor.asyncUpdateNode();
            }
        }, 3000L, TimeUnit.MILLISECONDS);
    }

    public static class Tag {
        private String name;
        private String value;
        private String type;
        private String decription;

        public String getDecription() {
            return this.decription;
        }

        public void setDecription(String decription) {
            this.decription = decription;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toString() {
            return JSON.toJSONString(this);
        }
    }

    static enum NotifyEvent {
        SWITCH_CHEANGE,
        UNIT_CHANGE,
        SITE_CHANGE;

    }

    private static class NodeUpdater
    implements Runnable {
        List<String> ips = new ArrayList<String>();

        public NodeUpdater(Set<String> ips) {
            this.ips = new ArrayList<String>(ips);
        }

        @Override
        public void run() {
            try {
                if (!enableAutoUpdate) {
                    VIPClient.LOG.info("NODE-UPDATE", "auto update is disabled.");
                    return;
                }
                boolean successful = true;
                int count = this.ips.size() / 200;
                if (this.ips.size() % 200 != 0) {
                    ++count;
                }
                if (CollectionUtils.isEmpty(this.ips)) {
                    return;
                }
                for (int i = 0; i < count; ++i) {
                    ArrayList<String> tmpIPs = new ArrayList<String>();
                    for (int j = i * 200; j < 200 * (i + 1) && j < this.ips.size(); ++j) {
                        tmpIPs.add(this.ips.get(j));
                    }
                    String string = StringUtils.join(tmpIPs, ",");
                    if (NodeReactor.updateNodeNow(string, false)) continue;
                    successful = false;
                    break;
                }
                NodeReactor.writeAllHosts2Disk();
                if (successful) {
                    NotifyEvent event = NotifyEvent.UNIT_CHANGE;
                    dispatcher.submit(new NotifyTask(event));
                }
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "failed to update node from server, ips: " + this.ips, e);
            }
        }
    }

    private static class NotifyTask
    implements Runnable {
        NotifyEvent event;

        public NotifyTask(NotifyEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            try {
                switch (this.event) {
                    case UNIT_CHANGE: {
                        NodeReactor.onIPChanges();
                        break;
                    }
                    case SWITCH_CHEANGE: {
                        NodeReactor.onSwitchChange();
                        break;
                    }
                }
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "failed to notify observers when node or switch is changed.", e);
            }
        }
    }

    private static class HostCache {
        private LoadingCache<String, Host> hostsMap = CacheBuilder.newBuilder().maximumSize(100000L).build(new CacheLoader<String, Host>(){

            @Override
            public Host load(String aString) throws Exception {
                return NodeReactor.getNode(aString);
            }
        });

        private HostCache() {
        }

        public Host get(String key) {
            try {
                return this.hostsMap.get(key);
            }
            catch (Exception e) {
                VIPClient.LOG.error("NA", "Exception while get key from cache: " + key, e);
                return null;
            }
        }

        public void put(String key, Host host) {
            this.hostsMap.put(key, host);
        }

        Map<String, Host> asMap() {
            return this.hostsMap.asMap();
        }

        void refreshCache(String key) {
            this.hostsMap.refresh(key);
        }
    }
}

